// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_IMAGE_COPY_IMAGE_BITMAP_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_IMAGE_COPY_IMAGE_BITMAP_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUOrigin2DDict;
class ImageBitmap;
class V8UnionGPUOrigin2DDictOrUnsignedLongEnforceRangeSequence;

class MODULES_EXPORT GPUImageCopyImageBitmap : public bindings::DictionaryBase {
  
  public:
static GPUImageCopyImageBitmap* Create() {
  return MakeGarbageCollected<GPUImageCopyImageBitmap>();
}
static GPUImageCopyImageBitmap* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUImageCopyImageBitmap>(isolate);
}
static GPUImageCopyImageBitmap* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUImageCopyImageBitmap();
explicit  GPUImageCopyImageBitmap(v8::Isolate* isolate);

bool hasImageBitmap() const {
  return true;
}
ImageBitmap* imageBitmap() const {
  return member_image_bitmap_.Get();
}
void setImageBitmap(ImageBitmap* value) {
  member_image_bitmap_ = value;
DCHECK(member_image_bitmap_);
}

bool hasOrigin() const {
  return true;
}
V8UnionGPUOrigin2DDictOrUnsignedLongEnforceRangeSequence* origin() const {
  return member_origin_.Get();
}
void setOrigin(V8UnionGPUOrigin2DDictOrUnsignedLongEnforceRangeSequence* value) {
  member_origin_ = value;
DCHECK(member_origin_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<ImageBitmap> member_image_bitmap_;
Member<V8UnionGPUOrigin2DDictOrUnsignedLongEnforceRangeSequence> member_origin_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_IMAGE_COPY_IMAGE_BITMAP_H_
