// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_DEVICE_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_DEVICE_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_feature_name.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_object_descriptor_base.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class GPUQueueDescriptor;
class V8UnionUndefinedOrUnsignedLongLongEnforceRange;

class MODULES_EXPORT GPUDeviceDescriptor : public GPUObjectDescriptorBase {
  
  public:
static GPUDeviceDescriptor* Create() {
  return MakeGarbageCollected<GPUDeviceDescriptor>();
}
static GPUDeviceDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUDeviceDescriptor>(isolate);
}
static GPUDeviceDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUDeviceDescriptor();
explicit  GPUDeviceDescriptor(v8::Isolate* isolate);

bool hasDefaultQueue() const {
  return true;
}
GPUQueueDescriptor* defaultQueue() const {
  return member_default_queue_.Get();
}
void setDefaultQueue(GPUQueueDescriptor* value) {
  member_default_queue_ = value;
DCHECK(member_default_queue_);
}

bool hasRequiredFeatures() const {
  return true;
}
const Vector<V8GPUFeatureName>& requiredFeatures() const {
  return member_required_features_;
}
void setRequiredFeatures(const Vector<V8GPUFeatureName>& value);
void setRequiredFeatures(Vector<V8GPUFeatureName>&& value);

bool hasRequiredLimits() const {
  return has_required_limits_;
}
const HeapVector<std::pair<String, Member<V8UnionUndefinedOrUnsignedLongLongEnforceRange>>>& requiredLimits() const {
  DCHECK(hasRequiredLimits());
return member_required_limits_;
}
HeapVector<std::pair<String, Member<V8UnionUndefinedOrUnsignedLongLongEnforceRange>>> getRequiredLimitsOr(const HeapVector<std::pair<String, Member<V8UnionUndefinedOrUnsignedLongLongEnforceRange>>>& fallback_value) const;
HeapVector<std::pair<String, Member<V8UnionUndefinedOrUnsignedLongLongEnforceRange>>> getRequiredLimitsOr(HeapVector<std::pair<String, Member<V8UnionUndefinedOrUnsignedLongLongEnforceRange>>>&& fallback_value) const;
void setRequiredLimits(const HeapVector<std::pair<String, Member<V8UnionUndefinedOrUnsignedLongLongEnforceRange>>>& value);
void setRequiredLimits(HeapVector<std::pair<String, Member<V8UnionUndefinedOrUnsignedLongLongEnforceRange>>>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUObjectDescriptorBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_required_limits_ = false;

Member<GPUQueueDescriptor> member_default_queue_;
Vector<V8GPUFeatureName> member_required_features_;
HeapVector<std::pair<String, Member<V8UnionUndefinedOrUnsignedLongLongEnforceRange>>> member_required_limits_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_DEVICE_DESCRIPTOR_H_
