// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_COLOR_TARGET_STATE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_COLOR_TARGET_STATE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_format.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUBlendState;

class MODULES_EXPORT GPUColorTargetState : public bindings::InputDictionaryBase {
  
  public:
static GPUColorTargetState* Create() {
  return MakeGarbageCollected<GPUColorTargetState>();
}
static GPUColorTargetState* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUColorTargetState>(isolate);
}
static GPUColorTargetState* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUColorTargetState();
explicit  GPUColorTargetState(v8::Isolate* isolate);

bool hasBlend() const {
  return has_blend_;
}
GPUBlendState* blend() const {
  DCHECK(hasBlend());
return member_blend_.Get();
}
GPUBlendState* getBlendOr(GPUBlendState* fallback_value) const {
  if (!hasBlend()) {
  return fallback_value;
}
return member_blend_.Get();
}
void setBlend(GPUBlendState* value) {
  member_blend_ = value;
has_blend_ = true;
DCHECK(member_blend_);
}

bool hasFormat() const {
  return true;
}
V8GPUTextureFormat format() const {
  return member_format_;
}
void setFormat(V8GPUTextureFormat value) {
  member_format_ = value;
}
void setFormat(V8GPUTextureFormat::Enum value) {
  member_format_ = V8GPUTextureFormat(value);
}

bool hasWriteMask() const {
  return true;
}
uint32_t writeMask() const {
  return member_write_mask_;
}
void setWriteMask(uint32_t value) {
  member_write_mask_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_blend_ = false;

Member<GPUBlendState> member_blend_;
V8GPUTextureFormat member_format_{static_cast<V8GPUTextureFormat::Enum>(0)};
uint32_t member_write_mask_{15};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_COLOR_TARGET_STATE_H_
