// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_canvas_configuration.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_canvas_tone_mapping.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_device.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"alphaMode",
"colorSpace",
"device",
"format",
"toneMapping",
"usage",
"viewFormats",
};


}  // namespace 

GPUCanvasConfiguration* GPUCanvasConfiguration::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  GPUCanvasConfiguration* dictionary = MakeGarbageCollected<GPUCanvasConfiguration>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "GPUCanvasConfiguration";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 GPUCanvasConfiguration::GPUCanvasConfiguration() : member_tone_mapping_(GPUCanvasToneMapping::Create()) {
  
}

 GPUCanvasConfiguration::GPUCanvasConfiguration(v8::Isolate* isolate) : member_tone_mapping_(GPUCanvasToneMapping::Create()) {
  
}

































void GPUCanvasConfiguration::setViewFormats(const Vector<V8GPUTextureFormat>& value) {
  member_view_formats_ = value;
}

void GPUCanvasConfiguration::setViewFormats(Vector<V8GPUTextureFormat>&& value) {
  member_view_formats_ = std::move(value);
}




void GPUCanvasConfiguration::Trace(Visitor* visitor) const {
  visitor->Trace(member_device_);
visitor->Trace(member_tone_mapping_);
bindings::DictionaryBase::Trace(visitor);
}

void GPUCanvasConfiguration::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void GPUCanvasConfiguration::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAlphaMode()) {
  values[0] = ToV8Traits<V8GPUCanvasAlphaMode>::ToV8(script_state, member_alpha_mode_);
DCHECK(!values[0].IsEmpty());
}
if (hasColorSpace()) {
  values[1] = ToV8Traits<V8PredefinedColorSpace>::ToV8(script_state, member_color_space_);
DCHECK(!values[1].IsEmpty());
}
if (hasDevice()) {
  values[2] = ToV8Traits<GPUDevice>::ToV8(script_state, member_device_.Get());
DCHECK(!values[2].IsEmpty());
}
if (hasFormat()) {
  values[3] = ToV8Traits<V8GPUTextureFormat>::ToV8(script_state, member_format_);
DCHECK(!values[3].IsEmpty());
}
if (hasToneMapping()) {
  values[4] = ToV8Traits<GPUCanvasToneMapping>::ToV8(script_state, member_tone_mapping_.Get());
DCHECK(!values[4].IsEmpty());
}
if (hasUsage()) {
  values[5] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_usage_);
DCHECK(!values[5].IsEmpty());
}
if (hasViewFormats()) {
  values[6] = ToV8Traits<IDLSequence<V8GPUTextureFormat>>::ToV8(script_state, member_view_formats_);
DCHECK(!values[6].IsEmpty());
}
}

const void* GPUCanvasConfiguration::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> GPUCanvasConfiguration::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void GPUCanvasConfiguration::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "GPUCanvasConfiguration";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("alphaMode");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8GPUCanvasAlphaMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_alpha_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("colorSpace");
if (!bindings::GetDictionaryMemberFromV8Object<V8PredefinedColorSpace, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_color_space_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("device");
constexpr bool is_required = true;
if (!bindings::GetDictionaryMemberFromV8Object<GPUDevice, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_device_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("format");
if (!bindings::GetDictionaryMemberFromV8Object<V8GPUTextureFormat, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_format_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("toneMapping");
if (!bindings::GetDictionaryMemberFromV8Object<GPUCanvasToneMapping, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_tone_mapping_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("usage");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_usage_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("viewFormats");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8GPUTextureFormat>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_view_formats_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> GPUCanvasConfiguration::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
