// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BLEND_STATE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BLEND_STATE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUBlendComponent;

class MODULES_EXPORT GPUBlendState : public bindings::InputDictionaryBase {
  
  public:
static GPUBlendState* Create() {
  return MakeGarbageCollected<GPUBlendState>();
}
static GPUBlendState* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUBlendState>(isolate);
}
static GPUBlendState* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUBlendState();
explicit  GPUBlendState(v8::Isolate* isolate);

bool hasAlpha() const {
  return true;
}
GPUBlendComponent* alpha() const {
  return member_alpha_.Get();
}
void setAlpha(GPUBlendComponent* value) {
  member_alpha_ = value;
DCHECK(member_alpha_);
}

bool hasColor() const {
  return true;
}
GPUBlendComponent* color() const {
  return member_color_.Get();
}
void setColor(GPUBlendComponent* value) {
  member_color_ = value;
DCHECK(member_color_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<GPUBlendComponent> member_alpha_;
Member<GPUBlendComponent> member_color_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BLEND_STATE_H_
