// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GAMEPAD_EFFECT_PARAMETERS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GAMEPAD_EFFECT_PARAMETERS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GamepadEffectParameters : public bindings::InputDictionaryBase {
  
  public:
static GamepadEffectParameters* Create() {
  return MakeGarbageCollected<GamepadEffectParameters>();
}
static GamepadEffectParameters* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GamepadEffectParameters>(isolate);
}
static GamepadEffectParameters* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GamepadEffectParameters();
explicit  GamepadEffectParameters(v8::Isolate* isolate);

bool hasDuration() const {
  return true;
}
double duration() const {
  return member_duration_;
}
void setDuration(double value) {
  member_duration_ = value;
}

bool hasLeftTrigger() const {
  return true;
}
double leftTrigger() const {
  return member_left_trigger_;
}
void setLeftTrigger(double value) {
  member_left_trigger_ = value;
}

bool hasRightTrigger() const {
  return true;
}
double rightTrigger() const {
  return member_right_trigger_;
}
void setRightTrigger(double value) {
  member_right_trigger_ = value;
}

bool hasStartDelay() const {
  return true;
}
double startDelay() const {
  return member_start_delay_;
}
void setStartDelay(double value) {
  member_start_delay_ = value;
}

bool hasStrongMagnitude() const {
  return true;
}
double strongMagnitude() const {
  return member_strong_magnitude_;
}
void setStrongMagnitude(double value) {
  member_strong_magnitude_ = value;
}

bool hasWeakMagnitude() const {
  return true;
}
double weakMagnitude() const {
  return member_weak_magnitude_;
}
void setWeakMagnitude(double value) {
  member_weak_magnitude_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



double member_duration_{0.0};
double member_left_trigger_{0.0};
double member_right_trigger_{0.0};
double member_start_delay_{0.0};
double member_strong_magnitude_{0.0};
double member_weak_magnitude_{0.0};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GAMEPAD_EFFECT_PARAMETERS_H_
