// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_SYSTEM_READ_WRITE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_SYSTEM_READ_WRITE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT FileSystemReadWriteOptions : public bindings::InputDictionaryBase {
  
  public:
static FileSystemReadWriteOptions* Create() {
  return MakeGarbageCollected<FileSystemReadWriteOptions>();
}
static FileSystemReadWriteOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<FileSystemReadWriteOptions>(isolate);
}
static FileSystemReadWriteOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  FileSystemReadWriteOptions();
explicit  FileSystemReadWriteOptions(v8::Isolate* isolate);

bool hasAt() const {
  return has_at_;
}
uint64_t at() const {
  DCHECK(hasAt());
return member_at_;
}
uint64_t getAtOr(uint64_t fallback_value) const {
  if (!hasAt()) {
  return fallback_value;
}
return member_at_;
}
void setAt(uint64_t value) {
  member_at_ = value;
has_at_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_at_ = false;

uint64_t member_at_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_SYSTEM_READ_WRITE_OPTIONS_H_
