// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_SYSTEM_FLAGS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_SYSTEM_FLAGS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT FileSystemFlags : public bindings::InputDictionaryBase {
  
  public:
static FileSystemFlags* Create() {
  return MakeGarbageCollected<FileSystemFlags>();
}
static FileSystemFlags* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<FileSystemFlags>(isolate);
}
static FileSystemFlags* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  FileSystemFlags();
explicit  FileSystemFlags(v8::Isolate* isolate);

bool hasCreateFlag() const {
  return true;
}
bool createFlag() const {
  return member_create_flag_;
}
void setCreateFlag(bool value) {
  member_create_flag_ = value;
}

bool hasExclusive() const {
  return true;
}
bool exclusive() const {
  return member_exclusive_;
}
void setExclusive(bool value) {
  member_exclusive_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_create_flag_{false};
bool member_exclusive_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_SYSTEM_FLAGS_H_
