// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_SYSTEM_CREATE_WRITABLE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_SYSTEM_CREATE_WRITABLE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_writable_file_stream_mode.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT FileSystemCreateWritableOptions : public bindings::InputDictionaryBase {
  
  public:
static FileSystemCreateWritableOptions* Create() {
  return MakeGarbageCollected<FileSystemCreateWritableOptions>();
}
static FileSystemCreateWritableOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<FileSystemCreateWritableOptions>(isolate);
}
static FileSystemCreateWritableOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  FileSystemCreateWritableOptions();
explicit  FileSystemCreateWritableOptions(v8::Isolate* isolate);

bool hasAutoClose() const {
  return true;
}
bool autoClose() const {
  return member_auto_close_;
}
void setAutoClose(bool value) {
  member_auto_close_ = value;
}

bool hasKeepExistingData() const {
  return true;
}
bool keepExistingData() const {
  return member_keep_existing_data_;
}
void setKeepExistingData(bool value) {
  member_keep_existing_data_ = value;
}

bool hasMode() const {
  return true;
}
V8FileSystemWritableFileStreamMode mode() const {
  return member_mode_;
}
void setMode(V8FileSystemWritableFileStreamMode value) {
  member_mode_ = value;
}
void setMode(V8FileSystemWritableFileStreamMode::Enum value) {
  member_mode_ = V8FileSystemWritableFileStreamMode(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_auto_close_{false};
bool member_keep_existing_data_{false};
V8FileSystemWritableFileStreamMode member_mode_{V8FileSystemWritableFileStreamMode::Enum::kSiloed};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_SYSTEM_CREATE_WRITABLE_OPTIONS_H_
