// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_change_record.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/modules/file_system_access/file_system_handle.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"changedHandle",
"relativePathComponents",
"relativePathMovedFrom",
"root",
"type",
};


}  // namespace 

FileSystemChangeRecord* FileSystemChangeRecord::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  FileSystemChangeRecord* dictionary = MakeGarbageCollected<FileSystemChangeRecord>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "FileSystemChangeRecord";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 FileSystemChangeRecord::FileSystemChangeRecord() {
  
}

 FileSystemChangeRecord::FileSystemChangeRecord(v8::Isolate* isolate) {
  
}










Vector<String> FileSystemChangeRecord::getRelativePathComponentsOr(const Vector<String>& fallback_value) const {
  if (!hasRelativePathComponents()) {
  return fallback_value;
}
return member_relative_path_components_;
}

Vector<String> FileSystemChangeRecord::getRelativePathComponentsOr(Vector<String>&& fallback_value) const {
  if (!hasRelativePathComponents()) {
  return std::move(fallback_value);
}
return member_relative_path_components_;
}

void FileSystemChangeRecord::setRelativePathComponents(const Vector<String>& value) {
  member_relative_path_components_ = value;
has_relative_path_components_ = true;
}

void FileSystemChangeRecord::setRelativePathComponents(Vector<String>&& value) {
  member_relative_path_components_ = std::move(value);
has_relative_path_components_ = true;
}




std::optional<Vector<String>> FileSystemChangeRecord::getRelativePathMovedFromOr(const std::optional<Vector<String>>& fallback_value) const {
  if (!hasRelativePathMovedFrom()) {
  return fallback_value;
}
return member_relative_path_moved_from_;
}

std::optional<Vector<String>> FileSystemChangeRecord::getRelativePathMovedFromOr(std::optional<Vector<String>>&& fallback_value) const {
  if (!hasRelativePathMovedFrom()) {
  return std::move(fallback_value);
}
return member_relative_path_moved_from_;
}

void FileSystemChangeRecord::setRelativePathMovedFrom(const std::optional<Vector<String>>& value) {
  member_relative_path_moved_from_ = value;
has_relative_path_moved_from_ = true;
}

void FileSystemChangeRecord::setRelativePathMovedFrom(std::optional<Vector<String>>&& value) {
  member_relative_path_moved_from_ = std::move(value);
has_relative_path_moved_from_ = true;
}

void FileSystemChangeRecord::setRelativePathMovedFrom(const Vector<String>& value) {
  member_relative_path_moved_from_ = value;
has_relative_path_moved_from_ = true;
}

void FileSystemChangeRecord::setRelativePathMovedFrom(Vector<String>&& value) {
  member_relative_path_moved_from_ = std::move(value);
has_relative_path_moved_from_ = true;
}

















void FileSystemChangeRecord::Trace(Visitor* visitor) const {
  visitor->Trace(member_changed_handle_);
visitor->Trace(member_root_);
bindings::DictionaryBase::Trace(visitor);
}

void FileSystemChangeRecord::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void FileSystemChangeRecord::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasChangedHandle()) {
  values[0] = ToV8Traits<IDLNullable<FileSystemHandle>>::ToV8(script_state, member_changed_handle_.Get());
DCHECK(!values[0].IsEmpty());
}
if (hasRelativePathComponents()) {
  values[1] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_relative_path_components_);
DCHECK(!values[1].IsEmpty());
}
if (hasRelativePathMovedFrom()) {
  values[2] = ToV8Traits<IDLNullable<IDLSequence<IDLString>>>::ToV8(script_state, member_relative_path_moved_from_);
DCHECK(!values[2].IsEmpty());
}
if (hasRoot()) {
  values[3] = ToV8Traits<FileSystemHandle>::ToV8(script_state, member_root_.Get());
DCHECK(!values[3].IsEmpty());
}
if (hasType()) {
  values[4] = ToV8Traits<V8FileSystemChangeType>::ToV8(script_state, member_type_);
DCHECK(!values[4].IsEmpty());
}
}

const void* FileSystemChangeRecord::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> FileSystemChangeRecord::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void FileSystemChangeRecord::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "FileSystemChangeRecord";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("changedHandle");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<FileSystemHandle>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_changed_handle_, member_changed_handle_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("relativePathComponents");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_relative_path_components_, member_relative_path_components_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("relativePathMovedFrom");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLSequence<IDLString>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_relative_path_moved_from_, member_relative_path_moved_from_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("root");
if (!bindings::GetDictionaryMemberFromV8Object<FileSystemHandle, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_root_, member_root_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("type");
if (!bindings::GetDictionaryMemberFromV8Object<V8FileSystemChangeType, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_type_, member_type_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> FileSystemChangeRecord::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
