// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FETCH_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FETCH_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_extendable_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class Request;

class MODULES_EXPORT FetchEventInit : public ExtendableEventInit {
  
  public:
static FetchEventInit* Create() {
  return MakeGarbageCollected<FetchEventInit>();
}
static FetchEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<FetchEventInit>(isolate);
}
static FetchEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  FetchEventInit();
explicit  FetchEventInit(v8::Isolate* isolate);

bool hasClientId() const {
  return true;
}
const String& clientId() const {
  return member_client_id_;
}
void setClientId(const String& value);
void setClientId(String&& value);

bool hasIsReload() const {
  return true;
}
bool isReload() const {
  return member_is_reload_;
}
void setIsReload(bool value) {
  member_is_reload_ = value;
}

bool hasRequest() const {
  return true;
}
Request* request() const {
  return member_request_.Get();
}
void setRequest(Request* value) {
  member_request_ = value;
DCHECK(member_request_);
}

bool hasResultingClientId() const {
  return true;
}
const String& resultingClientId() const {
  return member_resulting_client_id_;
}
void setResultingClientId(const String& value);
void setResultingClientId(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = ExtendableEventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



String member_client_id_{""};
bool member_is_reload_{false};
Member<Request> member_request_;
String member_resulting_client_id_{""};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FETCH_EVENT_INIT_H_
