// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_encoded_video_chunk_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybufferallowshared_arraybufferviewallowshared.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_decrypt_config.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"data",
"decryptConfig",
"duration",
"timestamp",
"transfer",
"type",
};


}  // namespace 

EncodedVideoChunkInit* EncodedVideoChunkInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  EncodedVideoChunkInit* dictionary = MakeGarbageCollected<EncodedVideoChunkInit>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "EncodedVideoChunkInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 EncodedVideoChunkInit::EncodedVideoChunkInit() {
  
}

 EncodedVideoChunkInit::EncodedVideoChunkInit(v8::Isolate* isolate) {
  
}



























void EncodedVideoChunkInit::setTransfer(const HeapVector<Member<DOMArrayBuffer>>& value) {
  member_transfer_ = value;
}

void EncodedVideoChunkInit::setTransfer(HeapVector<Member<DOMArrayBuffer>>&& value) {
  member_transfer_ = std::move(value);
}









void EncodedVideoChunkInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_data_);
visitor->Trace(member_decrypt_config_);
visitor->Trace(member_transfer_);
bindings::InputDictionaryBase::Trace(visitor);
}

void EncodedVideoChunkInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "EncodedVideoChunkInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("data");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_data_, class_like_name, exception_state)) {
  return;
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
constexpr bool is_optional = false;
if (RuntimeEnabledFeatures::MediaSourceExtensionsForWebCodecsEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("decryptConfig");
if (!bindings::GetDictionaryMemberFromV8Object<DecryptConfig, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_decrypt_config_, member_decrypt_config_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("duration");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_duration_, member_duration_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("timestamp");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLongLongEnforceRange, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_timestamp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("transfer");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<DOMArrayBuffer>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_transfer_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("type");
if (!bindings::GetDictionaryMemberFromV8Object<V8EncodedVideoChunkType, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_type_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> EncodedVideoChunkInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
