// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_display_media_stream_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_track_constraints.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_boolean_mediatrackconstraints.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/modules/mediastream/capture_controller.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"audio",
"controller",
"monitorTypeSurfaces",
"preferCurrentTab",
"selfBrowserSurface",
"surfaceSwitching",
"systemAudio",
"video",
"windowAudio",
};


}  // namespace 

DisplayMediaStreamOptions* DisplayMediaStreamOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  DisplayMediaStreamOptions* dictionary = MakeGarbageCollected<DisplayMediaStreamOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "DisplayMediaStreamOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 DisplayMediaStreamOptions::DisplayMediaStreamOptions() : member_audio_(MakeGarbageCollected<V8UnionBooleanOrMediaTrackConstraints>(false)), member_video_(MakeGarbageCollected<V8UnionBooleanOrMediaTrackConstraints>(true)) {
  
}

 DisplayMediaStreamOptions::DisplayMediaStreamOptions(v8::Isolate* isolate) : member_audio_(MakeGarbageCollected<V8UnionBooleanOrMediaTrackConstraints>(false)), member_video_(MakeGarbageCollected<V8UnionBooleanOrMediaTrackConstraints>(true)) {
  
}




























































void DisplayMediaStreamOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_audio_);
visitor->Trace(member_controller_);
visitor->Trace(member_video_);
bindings::InputDictionaryBase::Trace(visitor);
}

void DisplayMediaStreamOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "DisplayMediaStreamOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("audio");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrMediaTrackConstraints, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_audio_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::CaptureControllerEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("controller");
if (!bindings::GetDictionaryMemberFromV8Object<CaptureController, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_controller_, member_controller_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("monitorTypeSurfaces");
if (!bindings::GetDictionaryMemberFromV8Object<V8DisplayMediaIncludeOrExclude, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_monitor_type_surfaces_, member_monitor_type_surfaces_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("preferCurrentTab");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_prefer_current_tab_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("selfBrowserSurface");
if (!bindings::GetDictionaryMemberFromV8Object<V8DisplayMediaIncludeOrExclude, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_self_browser_surface_, member_self_browser_surface_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("surfaceSwitching");
if (!bindings::GetDictionaryMemberFromV8Object<V8DisplayMediaIncludeOrExclude, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_surface_switching_, member_surface_switching_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("systemAudio");
if (!bindings::GetDictionaryMemberFromV8Object<V8DisplayMediaIncludeOrExclude, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_system_audio_, member_system_audio_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("video");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrMediaTrackConstraints, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_video_, class_like_name, exception_state)) {
  return;
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::GetDisplayMediaWindowAudioCaptureEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("windowAudio");
if (!bindings::GetDictionaryMemberFromV8Object<V8DisplayMediaSystemWindowOrExclude, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_window_audio_, member_window_audio_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> DisplayMediaStreamOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
