// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DEVICE_MOTION_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DEVICE_MOTION_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class DeviceMotionEventAccelerationInit;
class DeviceMotionEventRotationRateInit;
class ExceptionState;

class MODULES_EXPORT DeviceMotionEventInit : public EventInit {
  
  public:
static DeviceMotionEventInit* Create() {
  return MakeGarbageCollected<DeviceMotionEventInit>();
}
static DeviceMotionEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<DeviceMotionEventInit>(isolate);
}
static DeviceMotionEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  DeviceMotionEventInit();
explicit  DeviceMotionEventInit(v8::Isolate* isolate);

bool hasAcceleration() const {
  return has_acceleration_;
}
DeviceMotionEventAccelerationInit* acceleration() const {
  DCHECK(hasAcceleration());
return member_acceleration_.Get();
}
DeviceMotionEventAccelerationInit* getAccelerationOr(DeviceMotionEventAccelerationInit* fallback_value) const {
  if (!hasAcceleration()) {
  return fallback_value;
}
return member_acceleration_.Get();
}
void setAcceleration(DeviceMotionEventAccelerationInit* value) {
  member_acceleration_ = value;
has_acceleration_ = true;
DCHECK(member_acceleration_);
}

bool hasAccelerationIncludingGravity() const {
  return has_acceleration_including_gravity_;
}
DeviceMotionEventAccelerationInit* accelerationIncludingGravity() const {
  DCHECK(hasAccelerationIncludingGravity());
return member_acceleration_including_gravity_.Get();
}
DeviceMotionEventAccelerationInit* getAccelerationIncludingGravityOr(DeviceMotionEventAccelerationInit* fallback_value) const {
  if (!hasAccelerationIncludingGravity()) {
  return fallback_value;
}
return member_acceleration_including_gravity_.Get();
}
void setAccelerationIncludingGravity(DeviceMotionEventAccelerationInit* value) {
  member_acceleration_including_gravity_ = value;
has_acceleration_including_gravity_ = true;
DCHECK(member_acceleration_including_gravity_);
}

bool hasInterval() const {
  return true;
}
double interval() const {
  return member_interval_;
}
void setInterval(double value) {
  member_interval_ = value;
}

bool hasRotationRate() const {
  return has_rotation_rate_;
}
DeviceMotionEventRotationRateInit* rotationRate() const {
  DCHECK(hasRotationRate());
return member_rotation_rate_.Get();
}
DeviceMotionEventRotationRateInit* getRotationRateOr(DeviceMotionEventRotationRateInit* fallback_value) const {
  if (!hasRotationRate()) {
  return fallback_value;
}
return member_rotation_rate_.Get();
}
void setRotationRate(DeviceMotionEventRotationRateInit* value) {
  member_rotation_rate_ = value;
has_rotation_rate_ = true;
DCHECK(member_rotation_rate_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_acceleration_ = false;
bool has_acceleration_including_gravity_ = false;
bool has_rotation_rate_ = false;

Member<DeviceMotionEventAccelerationInit> member_acceleration_;
Member<DeviceMotionEventAccelerationInit> member_acceleration_including_gravity_;
double member_interval_{0};
Member<DeviceMotionEventRotationRateInit> member_rotation_rate_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DEVICE_MOTION_EVENT_INIT_H_
