// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CREDENTIAL_CREATION_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CREDENTIAL_CREATION_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_credential_mediation_requirement.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AbortSignal;
class DigitalCredentialCreationOptions;
class ExceptionState;
class FederatedCredentialInit;
class HTMLFormElement;
class PasswordCredentialData;
class PublicKeyCredentialCreationOptions;
class V8UnionHTMLFormElementOrPasswordCredentialData;

class MODULES_EXPORT CredentialCreationOptions : public bindings::InputDictionaryBase {
  
  public:
static CredentialCreationOptions* Create() {
  return MakeGarbageCollected<CredentialCreationOptions>();
}
static CredentialCreationOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CredentialCreationOptions>(isolate);
}
static CredentialCreationOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CredentialCreationOptions();
explicit  CredentialCreationOptions(v8::Isolate* isolate);

bool hasDigital() const {
  return has_digital_;
}
DigitalCredentialCreationOptions* digital() const {
  DCHECK(hasDigital());
return member_digital_.Get();
}
DigitalCredentialCreationOptions* getDigitalOr(DigitalCredentialCreationOptions* fallback_value) const {
  if (!hasDigital()) {
  return fallback_value;
}
return member_digital_.Get();
}
void setDigital(DigitalCredentialCreationOptions* value) {
  member_digital_ = value;
has_digital_ = true;
DCHECK(member_digital_);
}

bool hasFederated() const {
  return has_federated_;
}
FederatedCredentialInit* federated() const {
  DCHECK(hasFederated());
return member_federated_.Get();
}
FederatedCredentialInit* getFederatedOr(FederatedCredentialInit* fallback_value) const {
  if (!hasFederated()) {
  return fallback_value;
}
return member_federated_.Get();
}
void setFederated(FederatedCredentialInit* value) {
  member_federated_ = value;
has_federated_ = true;
DCHECK(member_federated_);
}

bool hasMediation() const {
  return true;
}
V8CredentialMediationRequirement mediation() const {
  return member_mediation_;
}
void setMediation(V8CredentialMediationRequirement value) {
  member_mediation_ = value;
}
void setMediation(V8CredentialMediationRequirement::Enum value) {
  member_mediation_ = V8CredentialMediationRequirement(value);
}

bool hasPassword() const {
  return has_password_;
}
V8UnionHTMLFormElementOrPasswordCredentialData* password() const {
  DCHECK(hasPassword());
return member_password_.Get();
}
V8UnionHTMLFormElementOrPasswordCredentialData* getPasswordOr(V8UnionHTMLFormElementOrPasswordCredentialData* fallback_value) const {
  if (!hasPassword()) {
  return fallback_value;
}
return member_password_.Get();
}
void setPassword(V8UnionHTMLFormElementOrPasswordCredentialData* value) {
  member_password_ = value;
has_password_ = true;
DCHECK(member_password_);
}

bool hasPublicKey() const {
  return has_public_key_;
}
PublicKeyCredentialCreationOptions* publicKey() const {
  DCHECK(hasPublicKey());
return member_public_key_.Get();
}
PublicKeyCredentialCreationOptions* getPublicKeyOr(PublicKeyCredentialCreationOptions* fallback_value) const {
  if (!hasPublicKey()) {
  return fallback_value;
}
return member_public_key_.Get();
}
void setPublicKey(PublicKeyCredentialCreationOptions* value) {
  member_public_key_ = value;
has_public_key_ = true;
DCHECK(member_public_key_);
}

bool hasSignal() const {
  return has_signal_;
}
AbortSignal* signal() const {
  DCHECK(hasSignal());
return member_signal_.Get();
}
AbortSignal* getSignalOr(AbortSignal* fallback_value) const {
  if (!hasSignal()) {
  return fallback_value;
}
return member_signal_.Get();
}
void setSignal(AbortSignal* value) {
  member_signal_ = value;
has_signal_ = true;
DCHECK(member_signal_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_digital_ = false;
bool has_federated_ = false;
bool has_password_ = false;
bool has_public_key_ = false;
bool has_signal_ = false;

Member<DigitalCredentialCreationOptions> member_digital_;
Member<FederatedCredentialInit> member_federated_;
V8CredentialMediationRequirement member_mediation_{V8CredentialMediationRequirement::Enum::kOptional};
Member<V8UnionHTMLFormElementOrPasswordCredentialData> member_password_;
Member<PublicKeyCredentialCreationOptions> member_public_key_;
Member<AbortSignal> member_signal_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CREDENTIAL_CREATION_OPTIONS_H_
