// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_cookie_list_item.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"domain",
"expires",
"name",
"partitioned",
"path",
"sameSite",
"secure",
"value",
};


}  // namespace 

CookieListItem* CookieListItem::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  CookieListItem* dictionary = MakeGarbageCollected<CookieListItem>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "CookieListItem";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 CookieListItem::CookieListItem() {
  
}

 CookieListItem::CookieListItem(v8::Isolate* isolate) {
  
}



String CookieListItem::getDomainOr(const String& fallback_value) const {
  if (!hasDomain()) {
  return fallback_value;
}
return member_domain_;
}

String CookieListItem::getDomainOr(String&& fallback_value) const {
  if (!hasDomain()) {
  return std::move(fallback_value);
}
return member_domain_;
}

void CookieListItem::setDomain(const String& value) {
  member_domain_ = value;
has_domain_ = true;
}

void CookieListItem::setDomain(String&& value) {
  member_domain_ = std::move(value);
has_domain_ = true;
}











String CookieListItem::getNameOr(const String& fallback_value) const {
  if (!hasName()) {
  return fallback_value;
}
return member_name_;
}

String CookieListItem::getNameOr(String&& fallback_value) const {
  if (!hasName()) {
  return std::move(fallback_value);
}
return member_name_;
}

void CookieListItem::setName(const String& value) {
  member_name_ = value;
has_name_ = true;
}

void CookieListItem::setName(String&& value) {
  member_name_ = std::move(value);
has_name_ = true;
}











String CookieListItem::getPathOr(const String& fallback_value) const {
  if (!hasPath()) {
  return fallback_value;
}
return member_path_;
}

String CookieListItem::getPathOr(String&& fallback_value) const {
  if (!hasPath()) {
  return std::move(fallback_value);
}
return member_path_;
}

void CookieListItem::setPath(const String& value) {
  member_path_ = value;
has_path_ = true;
}

void CookieListItem::setPath(String&& value) {
  member_path_ = std::move(value);
has_path_ = true;
}


















String CookieListItem::getValueOr(const String& fallback_value) const {
  if (!hasValue()) {
  return fallback_value;
}
return member_value_;
}

String CookieListItem::getValueOr(String&& fallback_value) const {
  if (!hasValue()) {
  return std::move(fallback_value);
}
return member_value_;
}

void CookieListItem::setValue(const String& value) {
  member_value_ = value;
has_value_ = true;
}

void CookieListItem::setValue(String&& value) {
  member_value_ = std::move(value);
has_value_ = true;
}




void CookieListItem::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void CookieListItem::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void CookieListItem::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasDomain()) {
  values[0] = ToV8Traits<IDLNullable<IDLUSVString>>::ToV8(script_state, member_domain_);
DCHECK(!values[0].IsEmpty());
}
if (hasExpires()) {
  values[1] = ToV8Traits<IDLNullable<IDLDouble>>::ToV8(script_state, member_expires_);
DCHECK(!values[1].IsEmpty());
}
if (hasName()) {
  values[2] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_name_);
DCHECK(!values[2].IsEmpty());
}
if (hasPartitioned()) {
  values[3] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_partitioned_);
DCHECK(!values[3].IsEmpty());
}
if (hasPath()) {
  values[4] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_path_);
DCHECK(!values[4].IsEmpty());
}
if (hasSameSite()) {
  values[5] = ToV8Traits<V8CookieSameSite>::ToV8(script_state, member_same_site_);
DCHECK(!values[5].IsEmpty());
}
if (hasSecure()) {
  values[6] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_secure_);
DCHECK(!values[6].IsEmpty());
}
if (hasValue()) {
  values[7] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_value_);
DCHECK(!values[7].IsEmpty());
}
}

const void* CookieListItem::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> CookieListItem::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void CookieListItem::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "CookieListItem";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("domain");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLUSVString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_domain_, member_domain_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("expires");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLDouble>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_expires_, member_expires_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("name");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_name_, member_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("partitioned");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_partitioned_, member_partitioned_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("path");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_path_, member_path_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sameSite");
if (!bindings::GetDictionaryMemberFromV8Object<V8CookieSameSite, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_same_site_, member_same_site_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("secure");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_secure_, member_secure_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("value");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_value_, member_value_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> CookieListItem::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
