// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CONVOLVER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CONVOLVER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_node_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AudioBuffer;
class ExceptionState;

class MODULES_EXPORT ConvolverOptions : public AudioNodeOptions {
  
  public:
static ConvolverOptions* Create() {
  return MakeGarbageCollected<ConvolverOptions>();
}
static ConvolverOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ConvolverOptions>(isolate);
}
static ConvolverOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ConvolverOptions();
explicit  ConvolverOptions(v8::Isolate* isolate);

bool hasBuffer() const {
  return has_buffer_;
}
AudioBuffer* buffer() const {
  DCHECK(hasBuffer());
return member_buffer_.Get();
}
AudioBuffer* getBufferOr(AudioBuffer* fallback_value) const {
  if (!hasBuffer()) {
  return fallback_value;
}
return member_buffer_.Get();
}
void setBuffer(AudioBuffer* value) {
  member_buffer_ = value;
has_buffer_ = true;
}

bool hasDisableNormalization() const {
  return true;
}
bool disableNormalization() const {
  return member_disable_normalization_;
}
void setDisableNormalization(bool value) {
  member_disable_normalization_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = AudioNodeOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_buffer_ = false;

Member<AudioBuffer> member_buffer_;
bool member_disable_normalization_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CONVOLVER_OPTIONS_H_
