// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CONTENT_DESCRIPTION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CONTENT_DESCRIPTION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_content_category.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ContentIconDefinition;
class ExceptionState;

class MODULES_EXPORT ContentDescription : public bindings::DictionaryBase {
  
  public:
static ContentDescription* Create() {
  return MakeGarbageCollected<ContentDescription>();
}
static ContentDescription* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ContentDescription>(isolate);
}
static ContentDescription* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ContentDescription();
explicit  ContentDescription(v8::Isolate* isolate);

bool hasCategory() const {
  return true;
}
V8ContentCategory category() const {
  return member_category_;
}
void setCategory(V8ContentCategory value) {
  member_category_ = value;
}
void setCategory(V8ContentCategory::Enum value) {
  member_category_ = V8ContentCategory(value);
}

bool hasDescription() const {
  return true;
}
const String& description() const {
  return member_description_;
}
void setDescription(const String& value);
void setDescription(String&& value);

bool hasIcons() const {
  return true;
}
const HeapVector<Member<ContentIconDefinition>>& icons() const {
  return member_icons_;
}
void setIcons(const HeapVector<Member<ContentIconDefinition>>& value);
void setIcons(HeapVector<Member<ContentIconDefinition>>&& value);

bool hasId() const {
  return true;
}
const String& id() const {
  return member_id_;
}
void setId(const String& value);
void setId(String&& value);

bool hasTitle() const {
  return true;
}
const String& title() const {
  return member_title_;
}
void setTitle(const String& value);
void setTitle(String&& value);

bool hasUrl() const {
  return true;
}
const String& url() const {
  return member_url_;
}
void setUrl(const String& value);
void setUrl(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8ContentCategory member_category_{V8ContentCategory::Enum::k};
String member_description_;
HeapVector<Member<ContentIconDefinition>> member_icons_;
String member_id_;
String member_title_;
String member_url_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CONTENT_DESCRIPTION_H_
