// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_contact_info.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/fileapi/blob.h"
#include "third_party/blink/renderer/modules/contacts_picker/contact_address.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"address",
"email",
"icon",
"name",
"tel",
};


}  // namespace 

ContactInfo* ContactInfo::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ContactInfo* dictionary = MakeGarbageCollected<ContactInfo>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ContactInfo";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ContactInfo::ContactInfo() {
  
}

 ContactInfo::ContactInfo(v8::Isolate* isolate) {
  
}



HeapVector<Member<ContactAddress>> ContactInfo::getAddressOr(const HeapVector<Member<ContactAddress>>& fallback_value) const {
  if (!hasAddress()) {
  return fallback_value;
}
return member_address_;
}

HeapVector<Member<ContactAddress>> ContactInfo::getAddressOr(HeapVector<Member<ContactAddress>>&& fallback_value) const {
  if (!hasAddress()) {
  return std::move(fallback_value);
}
return member_address_;
}

void ContactInfo::setAddress(const HeapVector<Member<ContactAddress>>& value) {
  member_address_ = value;
has_address_ = true;
}

void ContactInfo::setAddress(HeapVector<Member<ContactAddress>>&& value) {
  member_address_ = std::move(value);
has_address_ = true;
}




Vector<String> ContactInfo::getEmailOr(const Vector<String>& fallback_value) const {
  if (!hasEmail()) {
  return fallback_value;
}
return member_email_;
}

Vector<String> ContactInfo::getEmailOr(Vector<String>&& fallback_value) const {
  if (!hasEmail()) {
  return std::move(fallback_value);
}
return member_email_;
}

void ContactInfo::setEmail(const Vector<String>& value) {
  member_email_ = value;
has_email_ = true;
}

void ContactInfo::setEmail(Vector<String>&& value) {
  member_email_ = std::move(value);
has_email_ = true;
}




HeapVector<Member<Blob>> ContactInfo::getIconOr(const HeapVector<Member<Blob>>& fallback_value) const {
  if (!hasIcon()) {
  return fallback_value;
}
return member_icon_;
}

HeapVector<Member<Blob>> ContactInfo::getIconOr(HeapVector<Member<Blob>>&& fallback_value) const {
  if (!hasIcon()) {
  return std::move(fallback_value);
}
return member_icon_;
}

void ContactInfo::setIcon(const HeapVector<Member<Blob>>& value) {
  member_icon_ = value;
has_icon_ = true;
}

void ContactInfo::setIcon(HeapVector<Member<Blob>>&& value) {
  member_icon_ = std::move(value);
has_icon_ = true;
}




Vector<String> ContactInfo::getNameOr(const Vector<String>& fallback_value) const {
  if (!hasName()) {
  return fallback_value;
}
return member_name_;
}

Vector<String> ContactInfo::getNameOr(Vector<String>&& fallback_value) const {
  if (!hasName()) {
  return std::move(fallback_value);
}
return member_name_;
}

void ContactInfo::setName(const Vector<String>& value) {
  member_name_ = value;
has_name_ = true;
}

void ContactInfo::setName(Vector<String>&& value) {
  member_name_ = std::move(value);
has_name_ = true;
}




Vector<String> ContactInfo::getTelOr(const Vector<String>& fallback_value) const {
  if (!hasTel()) {
  return fallback_value;
}
return member_tel_;
}

Vector<String> ContactInfo::getTelOr(Vector<String>&& fallback_value) const {
  if (!hasTel()) {
  return std::move(fallback_value);
}
return member_tel_;
}

void ContactInfo::setTel(const Vector<String>& value) {
  member_tel_ = value;
has_tel_ = true;
}

void ContactInfo::setTel(Vector<String>&& value) {
  member_tel_ = std::move(value);
has_tel_ = true;
}




void ContactInfo::Trace(Visitor* visitor) const {
  visitor->Trace(member_address_);
visitor->Trace(member_icon_);
bindings::DictionaryBase::Trace(visitor);
}

void ContactInfo::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void ContactInfo::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAddress()) {
  values[0] = ToV8Traits<IDLSequence<ContactAddress>>::ToV8(script_state, member_address_);
DCHECK(!values[0].IsEmpty());
}
if (hasEmail()) {
  values[1] = ToV8Traits<IDLSequence<IDLUSVString>>::ToV8(script_state, member_email_);
DCHECK(!values[1].IsEmpty());
}
if (hasIcon()) {
  values[2] = ToV8Traits<IDLSequence<Blob>>::ToV8(script_state, member_icon_);
DCHECK(!values[2].IsEmpty());
}
if (hasName()) {
  values[3] = ToV8Traits<IDLSequence<IDLUSVString>>::ToV8(script_state, member_name_);
DCHECK(!values[3].IsEmpty());
}
if (hasTel()) {
  values[4] = ToV8Traits<IDLSequence<IDLUSVString>>::ToV8(script_state, member_tel_);
DCHECK(!values[4].IsEmpty());
}
}

const void* ContactInfo::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> ContactInfo::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void ContactInfo::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ContactInfo";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("address");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<ContactAddress>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_address_, member_address_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("email");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUSVString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_email_, member_email_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("icon");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<Blob>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_icon_, member_icon_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("name");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUSVString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_name_, member_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tel");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUSVString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_tel_, member_tel_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ContactInfo::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
