// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_collected_client_data.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"challenge",
"origin",
"tokenBindingId",
"type",
};


}  // namespace 

CollectedClientData* CollectedClientData::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  CollectedClientData* dictionary = MakeGarbageCollected<CollectedClientData>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "CollectedClientData";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 CollectedClientData::CollectedClientData() {
  
}

 CollectedClientData::CollectedClientData(v8::Isolate* isolate) {
  
}



void CollectedClientData::setChallenge(const String& value) {
  member_challenge_ = value;
}

void CollectedClientData::setChallenge(String&& value) {
  member_challenge_ = std::move(value);
}




void CollectedClientData::setOrigin(const String& value) {
  member_origin_ = value;
}

void CollectedClientData::setOrigin(String&& value) {
  member_origin_ = std::move(value);
}




String CollectedClientData::getTokenBindingIdOr(const String& fallback_value) const {
  if (!hasTokenBindingId()) {
  return fallback_value;
}
return member_token_binding_id_;
}

String CollectedClientData::getTokenBindingIdOr(String&& fallback_value) const {
  if (!hasTokenBindingId()) {
  return std::move(fallback_value);
}
return member_token_binding_id_;
}

void CollectedClientData::setTokenBindingId(const String& value) {
  member_token_binding_id_ = value;
has_token_binding_id_ = true;
}

void CollectedClientData::setTokenBindingId(String&& value) {
  member_token_binding_id_ = std::move(value);
has_token_binding_id_ = true;
}




void CollectedClientData::setType(const String& value) {
  member_type_ = value;
}

void CollectedClientData::setType(String&& value) {
  member_type_ = std::move(value);
}




void CollectedClientData::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void CollectedClientData::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void CollectedClientData::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasChallenge()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_challenge_);
DCHECK(!values[0].IsEmpty());
}
if (hasOrigin()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_origin_);
DCHECK(!values[1].IsEmpty());
}
if (hasTokenBindingId()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_token_binding_id_);
DCHECK(!values[2].IsEmpty());
}
if (hasType()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_type_);
DCHECK(!values[3].IsEmpty());
}
}

const void* CollectedClientData::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> CollectedClientData::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void CollectedClientData::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "CollectedClientData";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("challenge");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_challenge_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("origin");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_origin_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tokenBindingId");
constexpr bool is_optional = false;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_token_binding_id_, member_token_binding_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("type");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_type_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> CollectedClientData::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
