// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CAPTURED_MOUSE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CAPTURED_MOUSE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT CapturedMouseEventInit : public EventInit {
  
  public:
static CapturedMouseEventInit* Create() {
  return MakeGarbageCollected<CapturedMouseEventInit>();
}
static CapturedMouseEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CapturedMouseEventInit>(isolate);
}
static CapturedMouseEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CapturedMouseEventInit();
explicit  CapturedMouseEventInit(v8::Isolate* isolate);

bool hasSurfaceX() const {
  return true;
}
int32_t surfaceX() const {
  return member_surface_x_;
}
void setSurfaceX(int32_t value) {
  member_surface_x_ = value;
}

bool hasSurfaceY() const {
  return true;
}
int32_t surfaceY() const {
  return member_surface_y_;
}
void setSurfaceY(int32_t value) {
  member_surface_y_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



int32_t member_surface_x_{-1};
int32_t member_surface_y_{-1};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CAPTURED_MOUSE_EVENT_INIT_H_
