// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CAPTURE_HANDLE_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CAPTURE_HANDLE_CONFIG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT CaptureHandleConfig : public bindings::InputDictionaryBase {
  
  public:
static CaptureHandleConfig* Create() {
  return MakeGarbageCollected<CaptureHandleConfig>();
}
static CaptureHandleConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CaptureHandleConfig>(isolate);
}
static CaptureHandleConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CaptureHandleConfig();
explicit  CaptureHandleConfig(v8::Isolate* isolate);

bool hasExposeOrigin() const {
  return true;
}
bool exposeOrigin() const {
  return member_expose_origin_;
}
void setExposeOrigin(bool value) {
  member_expose_origin_ = value;
}

bool hasHandle() const {
  return true;
}
const String& handle() const {
  return member_handle_;
}
void setHandle(const String& value);
void setHandle(String&& value);

bool hasPermittedOrigins() const {
  return true;
}
const Vector<String>& permittedOrigins() const {
  return member_permitted_origins_;
}
void setPermittedOrigins(const Vector<String>& value);
void setPermittedOrigins(Vector<String>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_expose_origin_{false};
String member_handle_{""};
Vector<String> member_permitted_origins_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CAPTURE_HANDLE_CONFIG_H_
