// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_2d_gpu_transfer_option.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_device.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"device",
"label",
"requireZeroCopy",
"usage",
};


}  // namespace 

Canvas2dGPUTransferOption* Canvas2dGPUTransferOption::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  Canvas2dGPUTransferOption* dictionary = MakeGarbageCollected<Canvas2dGPUTransferOption>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "Canvas2dGPUTransferOption";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 Canvas2dGPUTransferOption::Canvas2dGPUTransferOption() {
  
}

 Canvas2dGPUTransferOption::Canvas2dGPUTransferOption(v8::Isolate* isolate) {
  
}










String Canvas2dGPUTransferOption::getLabelOr(const String& fallback_value) const {
  if (!hasLabel()) {
  return fallback_value;
}
return member_label_;
}

String Canvas2dGPUTransferOption::getLabelOr(String&& fallback_value) const {
  if (!hasLabel()) {
  return std::move(fallback_value);
}
return member_label_;
}

void Canvas2dGPUTransferOption::setLabel(const String& value) {
  member_label_ = value;
has_label_ = true;
}

void Canvas2dGPUTransferOption::setLabel(String&& value) {
  member_label_ = std::move(value);
has_label_ = true;
}














void Canvas2dGPUTransferOption::Trace(Visitor* visitor) const {
  visitor->Trace(member_device_);
bindings::InputDictionaryBase::Trace(visitor);
}

void Canvas2dGPUTransferOption::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "Canvas2dGPUTransferOption";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("device");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<GPUDevice, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_device_, member_device_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("label");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_label_, member_label_, class_like_name, exception_state)) {
  return;
}
bool fallback_presence_var;
if (RuntimeEnabledFeatures::WebGPUDeveloperFeaturesEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("requireZeroCopy");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_require_zero_copy_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("usage");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_usage_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> Canvas2dGPUTransferOption::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
