// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CABLE_AUTHENTICATION_DATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CABLE_AUTHENTICATION_DATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class V8UnionArrayBufferOrArrayBufferView;

class MODULES_EXPORT CableAuthenticationData : public bindings::DictionaryBase {
  
  public:
static CableAuthenticationData* Create() {
  return MakeGarbageCollected<CableAuthenticationData>();
}
static CableAuthenticationData* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CableAuthenticationData>(isolate);
}
static CableAuthenticationData* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CableAuthenticationData();
explicit  CableAuthenticationData(v8::Isolate* isolate);

bool hasAuthenticatorEid() const {
  return true;
}
V8UnionArrayBufferOrArrayBufferView* authenticatorEid() const {
  return member_authenticator_eid_.Get();
}
void setAuthenticatorEid(V8UnionArrayBufferOrArrayBufferView* value) {
  member_authenticator_eid_ = value;
DCHECK(member_authenticator_eid_);
}

bool hasClientEid() const {
  return true;
}
V8UnionArrayBufferOrArrayBufferView* clientEid() const {
  return member_client_eid_.Get();
}
void setClientEid(V8UnionArrayBufferOrArrayBufferView* value) {
  member_client_eid_ = value;
DCHECK(member_client_eid_);
}

bool hasSessionPreKey() const {
  return true;
}
V8UnionArrayBufferOrArrayBufferView* sessionPreKey() const {
  return member_session_pre_key_.Get();
}
void setSessionPreKey(V8UnionArrayBufferOrArrayBufferView* value) {
  member_session_pre_key_ = value;
DCHECK(member_session_pre_key_);
}

bool hasVersion() const {
  return true;
}
uint8_t version() const {
  return member_version_;
}
void setVersion(uint8_t value) {
  member_version_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<V8UnionArrayBufferOrArrayBufferView> member_authenticator_eid_;
Member<V8UnionArrayBufferOrArrayBufferView> member_client_eid_;
Member<V8UnionArrayBufferOrArrayBufferView> member_session_pre_key_;
uint8_t member_version_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CABLE_AUTHENTICATION_DATA_H_
