// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BLOB_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BLOB_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class Blob;
class ExceptionState;

class MODULES_EXPORT BlobEventInit : public EventInit {
  
  public:
static BlobEventInit* Create() {
  return MakeGarbageCollected<BlobEventInit>();
}
static BlobEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<BlobEventInit>(isolate);
}
static BlobEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  BlobEventInit();
explicit  BlobEventInit(v8::Isolate* isolate);

bool hasData() const {
  return true;
}
Blob* data() const {
  return member_data_.Get();
}
void setData(Blob* value) {
  member_data_ = value;
DCHECK(member_data_);
}

bool hasTimecode() const {
  return has_timecode_;
}
double timecode() const {
  DCHECK(hasTimecode());
return member_timecode_;
}
double getTimecodeOr(double fallback_value) const {
  if (!hasTimecode()) {
  return fallback_value;
}
return member_timecode_;
}
void setTimecode(double value) {
  member_timecode_ = value;
has_timecode_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_timecode_ = false;

Member<Blob> member_data_;
double member_timecode_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BLOB_EVENT_INIT_H_
