// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATOR_SELECTION_CRITERIA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATOR_SELECTION_CRITERIA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AuthenticatorSelectionCriteria : public bindings::DictionaryBase {
  
  public:
static AuthenticatorSelectionCriteria* Create() {
  return MakeGarbageCollected<AuthenticatorSelectionCriteria>();
}
static AuthenticatorSelectionCriteria* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuthenticatorSelectionCriteria>(isolate);
}
static AuthenticatorSelectionCriteria* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuthenticatorSelectionCriteria();
explicit  AuthenticatorSelectionCriteria(v8::Isolate* isolate);

bool hasAuthenticatorAttachment() const {
  return has_authenticator_attachment_;
}
const String& authenticatorAttachment() const {
  DCHECK(hasAuthenticatorAttachment());
return member_authenticator_attachment_;
}
String getAuthenticatorAttachmentOr(const String& fallback_value) const;
String getAuthenticatorAttachmentOr(String&& fallback_value) const;
void setAuthenticatorAttachment(const String& value);
void setAuthenticatorAttachment(String&& value);

bool hasRequireResidentKey() const {
  return true;
}
bool requireResidentKey() const {
  return member_require_resident_key_;
}
void setRequireResidentKey(bool value) {
  member_require_resident_key_ = value;
}

bool hasResidentKey() const {
  return has_resident_key_;
}
const String& residentKey() const {
  DCHECK(hasResidentKey());
return member_resident_key_;
}
String getResidentKeyOr(const String& fallback_value) const;
String getResidentKeyOr(String&& fallback_value) const;
void setResidentKey(const String& value);
void setResidentKey(String&& value);

bool hasUserVerification() const {
  return has_user_verification_;
}
const String& userVerification() const {
  DCHECK(hasUserVerification());
return member_user_verification_;
}
String getUserVerificationOr(const String& fallback_value) const;
String getUserVerificationOr(String&& fallback_value) const;
void setUserVerification(const String& value);
void setUserVerification(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_authenticator_attachment_ = false;
bool has_resident_key_ = false;
bool has_user_verification_ = false;

String member_authenticator_attachment_;
bool member_require_resident_key_{false};
String member_resident_key_;
String member_user_verification_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATOR_SELECTION_CRITERIA_H_
