// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATOR_ATTESTATION_RESPONSE_JS_ON_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATOR_ATTESTATION_RESPONSE_JS_ON_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AuthenticatorAttestationResponseJSON : public bindings::DictionaryBase {
  
  public:
static AuthenticatorAttestationResponseJSON* Create() {
  return MakeGarbageCollected<AuthenticatorAttestationResponseJSON>();
}
static AuthenticatorAttestationResponseJSON* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuthenticatorAttestationResponseJSON>(isolate);
}
static AuthenticatorAttestationResponseJSON* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuthenticatorAttestationResponseJSON();
explicit  AuthenticatorAttestationResponseJSON(v8::Isolate* isolate);

bool hasAttestationObject() const {
  return true;
}
const String& attestationObject() const {
  return member_attestation_object_;
}
void setAttestationObject(const String& value);
void setAttestationObject(String&& value);

bool hasAuthenticatorData() const {
  return true;
}
const String& authenticatorData() const {
  return member_authenticator_data_;
}
void setAuthenticatorData(const String& value);
void setAuthenticatorData(String&& value);

bool hasClientDataJSON() const {
  return true;
}
const String& clientDataJSON() const {
  return member_client_data_js_on_;
}
void setClientDataJSON(const String& value);
void setClientDataJSON(String&& value);

bool hasPublicKey() const {
  return has_public_key_;
}
const String& publicKey() const {
  DCHECK(hasPublicKey());
return member_public_key_;
}
String getPublicKeyOr(const String& fallback_value) const;
String getPublicKeyOr(String&& fallback_value) const;
void setPublicKey(const String& value);
void setPublicKey(String&& value);

bool hasPublicKeyAlgorithm() const {
  return true;
}
int64_t publicKeyAlgorithm() const {
  return member_public_key_algorithm_;
}
void setPublicKeyAlgorithm(int64_t value) {
  member_public_key_algorithm_ = value;
}

bool hasTransports() const {
  return true;
}
const Vector<String>& transports() const {
  return member_transports_;
}
void setTransports(const Vector<String>& value);
void setTransports(Vector<String>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_public_key_ = false;

String member_attestation_object_;
String member_authenticator_data_;
String member_client_data_js_on_;
String member_public_key_;
int64_t member_public_key_algorithm_;
Vector<String> member_transports_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATOR_ATTESTATION_RESPONSE_JS_ON_H_
