// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_SUPPLEMENTAL_PUB_KEYS_INPUTS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_SUPPLEMENTAL_PUB_KEYS_INPUTS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AuthenticationExtensionsSupplementalPubKeysInputs : public bindings::DictionaryBase {
  
  public:
static AuthenticationExtensionsSupplementalPubKeysInputs* Create() {
  return MakeGarbageCollected<AuthenticationExtensionsSupplementalPubKeysInputs>();
}
static AuthenticationExtensionsSupplementalPubKeysInputs* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuthenticationExtensionsSupplementalPubKeysInputs>(isolate);
}
static AuthenticationExtensionsSupplementalPubKeysInputs* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuthenticationExtensionsSupplementalPubKeysInputs();
explicit  AuthenticationExtensionsSupplementalPubKeysInputs(v8::Isolate* isolate);

bool hasAttestation() const {
  return true;
}
const String& attestation() const {
  return member_attestation_;
}
void setAttestation(const String& value);
void setAttestation(String&& value);

bool hasAttestationFormats() const {
  return true;
}
const Vector<String>& attestationFormats() const {
  return member_attestation_formats_;
}
void setAttestationFormats(const Vector<String>& value);
void setAttestationFormats(Vector<String>&& value);

bool hasScopes() const {
  return true;
}
const Vector<String>& scopes() const {
  return member_scopes_;
}
void setScopes(const Vector<String>& value);
void setScopes(Vector<String>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



String member_attestation_{"none"};
Vector<String> member_attestation_formats_;
Vector<String> member_scopes_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_SUPPLEMENTAL_PUB_KEYS_INPUTS_H_
