// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_PAYMENT_OUTPUTS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_PAYMENT_OUTPUTS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AuthenticationExtensionsPaymentBrowserBoundSignature;
class ExceptionState;

class MODULES_EXPORT AuthenticationExtensionsPaymentOutputs : public bindings::DictionaryBase {
  
  public:
static AuthenticationExtensionsPaymentOutputs* Create() {
  return MakeGarbageCollected<AuthenticationExtensionsPaymentOutputs>();
}
static AuthenticationExtensionsPaymentOutputs* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuthenticationExtensionsPaymentOutputs>(isolate);
}
static AuthenticationExtensionsPaymentOutputs* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuthenticationExtensionsPaymentOutputs();
explicit  AuthenticationExtensionsPaymentOutputs(v8::Isolate* isolate);

bool hasBrowserBoundSignature() const {
  return has_browser_bound_signature_;
}
AuthenticationExtensionsPaymentBrowserBoundSignature* browserBoundSignature() const {
  DCHECK(hasBrowserBoundSignature());
return member_browser_bound_signature_.Get();
}
AuthenticationExtensionsPaymentBrowserBoundSignature* getBrowserBoundSignatureOr(AuthenticationExtensionsPaymentBrowserBoundSignature* fallback_value) const {
  if (!hasBrowserBoundSignature()) {
  return fallback_value;
}
return member_browser_bound_signature_.Get();
}
void setBrowserBoundSignature(AuthenticationExtensionsPaymentBrowserBoundSignature* value) {
  member_browser_bound_signature_ = value;
has_browser_bound_signature_ = true;
DCHECK(member_browser_bound_signature_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_browser_bound_signature_ = false;

Member<AuthenticationExtensionsPaymentBrowserBoundSignature> member_browser_bound_signature_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_PAYMENT_OUTPUTS_H_
