// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_PAYMENT_INPUTS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_PAYMENT_INPUTS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class PublicKeyCredentialParameters;

class MODULES_EXPORT AuthenticationExtensionsPaymentInputs : public bindings::DictionaryBase {
  
  public:
static AuthenticationExtensionsPaymentInputs* Create() {
  return MakeGarbageCollected<AuthenticationExtensionsPaymentInputs>();
}
static AuthenticationExtensionsPaymentInputs* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuthenticationExtensionsPaymentInputs>(isolate);
}
static AuthenticationExtensionsPaymentInputs* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuthenticationExtensionsPaymentInputs();
explicit  AuthenticationExtensionsPaymentInputs(v8::Isolate* isolate);

bool hasBrowserBoundPubKeyCredParams() const {
  return has_browser_bound_pub_key_cred_params_;
}
const HeapVector<Member<PublicKeyCredentialParameters>>& browserBoundPubKeyCredParams() const {
  DCHECK(hasBrowserBoundPubKeyCredParams());
return member_browser_bound_pub_key_cred_params_;
}
HeapVector<Member<PublicKeyCredentialParameters>> getBrowserBoundPubKeyCredParamsOr(const HeapVector<Member<PublicKeyCredentialParameters>>& fallback_value) const;
HeapVector<Member<PublicKeyCredentialParameters>> getBrowserBoundPubKeyCredParamsOr(HeapVector<Member<PublicKeyCredentialParameters>>&& fallback_value) const;
void setBrowserBoundPubKeyCredParams(const HeapVector<Member<PublicKeyCredentialParameters>>& value);
void setBrowserBoundPubKeyCredParams(HeapVector<Member<PublicKeyCredentialParameters>>&& value);

bool hasIsPayment() const {
  return has_is_payment_;
}
bool isPayment() const {
  DCHECK(hasIsPayment());
return member_is_payment_;
}
bool getIsPaymentOr(bool fallback_value) const {
  if (!hasIsPayment()) {
  return fallback_value;
}
return member_is_payment_;
}
void setIsPayment(bool value) {
  member_is_payment_ = value;
has_is_payment_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_browser_bound_pub_key_cred_params_ = false;
bool has_is_payment_ = false;

HeapVector<Member<PublicKeyCredentialParameters>> member_browser_bound_pub_key_cred_params_;
bool member_is_payment_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_PAYMENT_INPUTS_H_
