// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_client_inputs_js_on.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_large_blob_inputs_js_on.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_payment_inputs.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_prf_inputs_js_on.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_supplemental_pub_keys_inputs.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_remote_desktop_client_override.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"appid",
"appidExclude",
"credBlob",
"credProps",
"credentialProtectionPolicy",
"enforceCredentialProtectionPolicy",
"getCredBlob",
"hmacCreateSecret",
"largeBlob",
"minPinLength",
"payment",
"prf",
"remoteDesktopClientOverride",
"supplementalPubKeys",
};


}  // namespace 

AuthenticationExtensionsClientInputsJSON* AuthenticationExtensionsClientInputsJSON::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AuthenticationExtensionsClientInputsJSON* dictionary = MakeGarbageCollected<AuthenticationExtensionsClientInputsJSON>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AuthenticationExtensionsClientInputsJSON";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AuthenticationExtensionsClientInputsJSON::AuthenticationExtensionsClientInputsJSON() {
  
}

 AuthenticationExtensionsClientInputsJSON::AuthenticationExtensionsClientInputsJSON(v8::Isolate* isolate) {
  
}



String AuthenticationExtensionsClientInputsJSON::getAppidOr(const String& fallback_value) const {
  if (!hasAppid()) {
  return fallback_value;
}
return member_appid_;
}

String AuthenticationExtensionsClientInputsJSON::getAppidOr(String&& fallback_value) const {
  if (!hasAppid()) {
  return std::move(fallback_value);
}
return member_appid_;
}

void AuthenticationExtensionsClientInputsJSON::setAppid(const String& value) {
  member_appid_ = value;
has_appid_ = true;
}

void AuthenticationExtensionsClientInputsJSON::setAppid(String&& value) {
  member_appid_ = std::move(value);
has_appid_ = true;
}




String AuthenticationExtensionsClientInputsJSON::getAppidExcludeOr(const String& fallback_value) const {
  if (!hasAppidExclude()) {
  return fallback_value;
}
return member_appid_exclude_;
}

String AuthenticationExtensionsClientInputsJSON::getAppidExcludeOr(String&& fallback_value) const {
  if (!hasAppidExclude()) {
  return std::move(fallback_value);
}
return member_appid_exclude_;
}

void AuthenticationExtensionsClientInputsJSON::setAppidExclude(const String& value) {
  member_appid_exclude_ = value;
has_appid_exclude_ = true;
}

void AuthenticationExtensionsClientInputsJSON::setAppidExclude(String&& value) {
  member_appid_exclude_ = std::move(value);
has_appid_exclude_ = true;
}




String AuthenticationExtensionsClientInputsJSON::getCredBlobOr(const String& fallback_value) const {
  if (!hasCredBlob()) {
  return fallback_value;
}
return member_cred_blob_;
}

String AuthenticationExtensionsClientInputsJSON::getCredBlobOr(String&& fallback_value) const {
  if (!hasCredBlob()) {
  return std::move(fallback_value);
}
return member_cred_blob_;
}

void AuthenticationExtensionsClientInputsJSON::setCredBlob(const String& value) {
  member_cred_blob_ = value;
has_cred_blob_ = true;
}

void AuthenticationExtensionsClientInputsJSON::setCredBlob(String&& value) {
  member_cred_blob_ = std::move(value);
has_cred_blob_ = true;
}









String AuthenticationExtensionsClientInputsJSON::getCredentialProtectionPolicyOr(const String& fallback_value) const {
  if (!hasCredentialProtectionPolicy()) {
  return fallback_value;
}
return member_credential_protection_policy_;
}

String AuthenticationExtensionsClientInputsJSON::getCredentialProtectionPolicyOr(String&& fallback_value) const {
  if (!hasCredentialProtectionPolicy()) {
  return std::move(fallback_value);
}
return member_credential_protection_policy_;
}

void AuthenticationExtensionsClientInputsJSON::setCredentialProtectionPolicy(const String& value) {
  member_credential_protection_policy_ = value;
has_credential_protection_policy_ = true;
}

void AuthenticationExtensionsClientInputsJSON::setCredentialProtectionPolicy(String&& value) {
  member_credential_protection_policy_ = std::move(value);
has_credential_protection_policy_ = true;
}

































































void AuthenticationExtensionsClientInputsJSON::Trace(Visitor* visitor) const {
  visitor->Trace(member_large_blob_);
visitor->Trace(member_payment_);
visitor->Trace(member_prf_);
visitor->Trace(member_remote_desktop_client_override_);
visitor->Trace(member_supplemental_pub_keys_);
bindings::InputDictionaryBase::Trace(visitor);
}

void AuthenticationExtensionsClientInputsJSON::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AuthenticationExtensionsClientInputsJSON";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("appid");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_appid_, member_appid_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("appidExclude");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_appid_exclude_, member_appid_exclude_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("credBlob");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_cred_blob_, member_cred_blob_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("credProps");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_cred_props_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("credentialProtectionPolicy");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_credential_protection_policy_, member_credential_protection_policy_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("enforceCredentialProtectionPolicy");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_enforce_credential_protection_policy_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("getCredBlob");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_get_cred_blob_, member_get_cred_blob_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hmacCreateSecret");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_hmac_create_secret_, member_hmac_create_secret_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("largeBlob");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticationExtensionsLargeBlobInputsJSON, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_large_blob_, member_large_blob_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("minPinLength");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_min_pin_length_, member_min_pin_length_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::SecurePaymentConfirmationEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("payment");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticationExtensionsPaymentInputs, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_payment_, member_payment_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("prf");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticationExtensionsPRFInputsJSON, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_prf_, member_prf_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::WebAuthenticationRemoteDesktopSupportEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("remoteDesktopClientOverride");
if (!bindings::GetDictionaryMemberFromV8Object<RemoteDesktopClientOverride, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_remote_desktop_client_override_, member_remote_desktop_client_override_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::WebAuthenticationSupplementalPubKeysEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("supplementalPubKeys");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticationExtensionsSupplementalPubKeysInputs, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_supplemental_pub_keys_, member_supplemental_pub_keys_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> AuthenticationExtensionsClientInputsJSON::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
