// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_CLIENT_INPUTS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_CLIENT_INPUTS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AuthenticationExtensionsLargeBlobInputs;
class AuthenticationExtensionsPRFInputs;
class AuthenticationExtensionsPaymentInputs;
class AuthenticationExtensionsSupplementalPubKeysInputs;
class CableAuthenticationData;
class ExceptionState;
class RemoteDesktopClientOverride;
class V8UnionArrayBufferOrArrayBufferView;

class MODULES_EXPORT AuthenticationExtensionsClientInputs : public bindings::DictionaryBase {
  
  public:
static AuthenticationExtensionsClientInputs* Create() {
  return MakeGarbageCollected<AuthenticationExtensionsClientInputs>();
}
static AuthenticationExtensionsClientInputs* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuthenticationExtensionsClientInputs>(isolate);
}
static AuthenticationExtensionsClientInputs* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuthenticationExtensionsClientInputs();
explicit  AuthenticationExtensionsClientInputs(v8::Isolate* isolate);

bool hasAppid() const {
  return has_appid_;
}
const String& appid() const {
  DCHECK(hasAppid());
return member_appid_;
}
String getAppidOr(const String& fallback_value) const;
String getAppidOr(String&& fallback_value) const;
void setAppid(const String& value);
void setAppid(String&& value);

bool hasAppidExclude() const {
  return has_appid_exclude_;
}
const String& appidExclude() const {
  DCHECK(hasAppidExclude());
return member_appid_exclude_;
}
String getAppidExcludeOr(const String& fallback_value) const;
String getAppidExcludeOr(String&& fallback_value) const;
void setAppidExclude(const String& value);
void setAppidExclude(String&& value);

bool hasCableAuthentication() const {
  return has_cable_authentication_;
}
const HeapVector<Member<CableAuthenticationData>>& cableAuthentication() const {
  DCHECK(hasCableAuthentication());
return member_cable_authentication_;
}
HeapVector<Member<CableAuthenticationData>> getCableAuthenticationOr(const HeapVector<Member<CableAuthenticationData>>& fallback_value) const;
HeapVector<Member<CableAuthenticationData>> getCableAuthenticationOr(HeapVector<Member<CableAuthenticationData>>&& fallback_value) const;
void setCableAuthentication(const HeapVector<Member<CableAuthenticationData>>& value);
void setCableAuthentication(HeapVector<Member<CableAuthenticationData>>&& value);

bool hasCredBlob() const {
  return has_cred_blob_;
}
V8UnionArrayBufferOrArrayBufferView* credBlob() const {
  DCHECK(hasCredBlob());
return member_cred_blob_.Get();
}
V8UnionArrayBufferOrArrayBufferView* getCredBlobOr(V8UnionArrayBufferOrArrayBufferView* fallback_value) const {
  if (!hasCredBlob()) {
  return fallback_value;
}
return member_cred_blob_.Get();
}
void setCredBlob(V8UnionArrayBufferOrArrayBufferView* value) {
  member_cred_blob_ = value;
has_cred_blob_ = true;
DCHECK(member_cred_blob_);
}

bool hasCredProps() const {
  return true;
}
bool credProps() const {
  return member_cred_props_;
}
void setCredProps(bool value) {
  member_cred_props_ = value;
}

bool hasCredentialProtectionPolicy() const {
  return has_credential_protection_policy_;
}
const String& credentialProtectionPolicy() const {
  DCHECK(hasCredentialProtectionPolicy());
return member_credential_protection_policy_;
}
String getCredentialProtectionPolicyOr(const String& fallback_value) const;
String getCredentialProtectionPolicyOr(String&& fallback_value) const;
void setCredentialProtectionPolicy(const String& value);
void setCredentialProtectionPolicy(String&& value);

bool hasEnforceCredentialProtectionPolicy() const {
  return true;
}
bool enforceCredentialProtectionPolicy() const {
  return member_enforce_credential_protection_policy_;
}
void setEnforceCredentialProtectionPolicy(bool value) {
  member_enforce_credential_protection_policy_ = value;
}

bool hasGetCredBlob() const {
  return has_get_cred_blob_;
}
bool getCredBlob() const {
  DCHECK(hasGetCredBlob());
return member_get_cred_blob_;
}
bool getGetCredBlobOr(bool fallback_value) const {
  if (!hasGetCredBlob()) {
  return fallback_value;
}
return member_get_cred_blob_;
}
void setGetCredBlob(bool value) {
  member_get_cred_blob_ = value;
has_get_cred_blob_ = true;
}

bool hasHmacCreateSecret() const {
  return has_hmac_create_secret_;
}
bool hmacCreateSecret() const {
  DCHECK(hasHmacCreateSecret());
return member_hmac_create_secret_;
}
bool getHmacCreateSecretOr(bool fallback_value) const {
  if (!hasHmacCreateSecret()) {
  return fallback_value;
}
return member_hmac_create_secret_;
}
void setHmacCreateSecret(bool value) {
  member_hmac_create_secret_ = value;
has_hmac_create_secret_ = true;
}

bool hasLargeBlob() const {
  return has_large_blob_;
}
AuthenticationExtensionsLargeBlobInputs* largeBlob() const {
  DCHECK(hasLargeBlob());
return member_large_blob_.Get();
}
AuthenticationExtensionsLargeBlobInputs* getLargeBlobOr(AuthenticationExtensionsLargeBlobInputs* fallback_value) const {
  if (!hasLargeBlob()) {
  return fallback_value;
}
return member_large_blob_.Get();
}
void setLargeBlob(AuthenticationExtensionsLargeBlobInputs* value) {
  member_large_blob_ = value;
has_large_blob_ = true;
DCHECK(member_large_blob_);
}

bool hasMinPinLength() const {
  return has_min_pin_length_;
}
bool minPinLength() const {
  DCHECK(hasMinPinLength());
return member_min_pin_length_;
}
bool getMinPinLengthOr(bool fallback_value) const {
  if (!hasMinPinLength()) {
  return fallback_value;
}
return member_min_pin_length_;
}
void setMinPinLength(bool value) {
  member_min_pin_length_ = value;
has_min_pin_length_ = true;
}

bool hasPayment() const {
  return has_payment_;
}
AuthenticationExtensionsPaymentInputs* payment() const {
  DCHECK(hasPayment());
return member_payment_.Get();
}
AuthenticationExtensionsPaymentInputs* getPaymentOr(AuthenticationExtensionsPaymentInputs* fallback_value) const {
  if (!hasPayment()) {
  return fallback_value;
}
return member_payment_.Get();
}
void setPayment(AuthenticationExtensionsPaymentInputs* value) {
  member_payment_ = value;
has_payment_ = true;
DCHECK(member_payment_);
}

bool hasPrf() const {
  return has_prf_;
}
AuthenticationExtensionsPRFInputs* prf() const {
  DCHECK(hasPrf());
return member_prf_.Get();
}
AuthenticationExtensionsPRFInputs* getPrfOr(AuthenticationExtensionsPRFInputs* fallback_value) const {
  if (!hasPrf()) {
  return fallback_value;
}
return member_prf_.Get();
}
void setPrf(AuthenticationExtensionsPRFInputs* value) {
  member_prf_ = value;
has_prf_ = true;
DCHECK(member_prf_);
}

bool hasRemoteDesktopClientOverride() const {
  return has_remote_desktop_client_override_;
}
RemoteDesktopClientOverride* remoteDesktopClientOverride() const {
  DCHECK(hasRemoteDesktopClientOverride());
return member_remote_desktop_client_override_.Get();
}
RemoteDesktopClientOverride* getRemoteDesktopClientOverrideOr(RemoteDesktopClientOverride* fallback_value) const {
  if (!hasRemoteDesktopClientOverride()) {
  return fallback_value;
}
return member_remote_desktop_client_override_.Get();
}
void setRemoteDesktopClientOverride(RemoteDesktopClientOverride* value) {
  member_remote_desktop_client_override_ = value;
has_remote_desktop_client_override_ = true;
DCHECK(member_remote_desktop_client_override_);
}

bool hasSupplementalPubKeys() const {
  return has_supplemental_pub_keys_;
}
AuthenticationExtensionsSupplementalPubKeysInputs* supplementalPubKeys() const {
  DCHECK(hasSupplementalPubKeys());
return member_supplemental_pub_keys_.Get();
}
AuthenticationExtensionsSupplementalPubKeysInputs* getSupplementalPubKeysOr(AuthenticationExtensionsSupplementalPubKeysInputs* fallback_value) const {
  if (!hasSupplementalPubKeys()) {
  return fallback_value;
}
return member_supplemental_pub_keys_.Get();
}
void setSupplementalPubKeys(AuthenticationExtensionsSupplementalPubKeysInputs* value) {
  member_supplemental_pub_keys_ = value;
has_supplemental_pub_keys_ = true;
DCHECK(member_supplemental_pub_keys_);
}

bool hasUvm() const {
  return has_uvm_;
}
bool uvm() const {
  DCHECK(hasUvm());
return member_uvm_;
}
bool getUvmOr(bool fallback_value) const {
  if (!hasUvm()) {
  return fallback_value;
}
return member_uvm_;
}
void setUvm(bool value) {
  member_uvm_ = value;
has_uvm_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 16;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_appid_ = false;
bool has_appid_exclude_ = false;
bool has_cable_authentication_ = false;
bool has_cred_blob_ = false;
bool has_credential_protection_policy_ = false;
bool has_get_cred_blob_ = false;
bool has_hmac_create_secret_ = false;
bool has_large_blob_ = false;
bool has_min_pin_length_ = false;
bool has_payment_ = false;
bool has_prf_ = false;
bool has_remote_desktop_client_override_ = false;
bool has_supplemental_pub_keys_ = false;
bool has_uvm_ = false;

String member_appid_;
String member_appid_exclude_;
HeapVector<Member<CableAuthenticationData>> member_cable_authentication_;
Member<V8UnionArrayBufferOrArrayBufferView> member_cred_blob_;
bool member_cred_props_{false};
String member_credential_protection_policy_;
bool member_enforce_credential_protection_policy_{false};
bool member_get_cred_blob_;
bool member_hmac_create_secret_;
Member<AuthenticationExtensionsLargeBlobInputs> member_large_blob_;
bool member_min_pin_length_;
Member<AuthenticationExtensionsPaymentInputs> member_payment_;
Member<AuthenticationExtensionsPRFInputs> member_prf_;
Member<RemoteDesktopClientOverride> member_remote_desktop_client_override_;
Member<AuthenticationExtensionsSupplementalPubKeysInputs> member_supplemental_pub_keys_;
bool member_uvm_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_CLIENT_INPUTS_H_
