// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_WORKLET_NODE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_WORKLET_NODE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_node_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AudioWorkletNodeOptions : public AudioNodeOptions {
  
  public:
static AudioWorkletNodeOptions* Create() {
  return MakeGarbageCollected<AudioWorkletNodeOptions>();
}
static AudioWorkletNodeOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AudioWorkletNodeOptions>(isolate);
}
static AudioWorkletNodeOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AudioWorkletNodeOptions();
explicit  AudioWorkletNodeOptions(v8::Isolate* isolate);

bool hasNumberOfInputs() const {
  return true;
}
uint32_t numberOfInputs() const {
  return member_number_of_inputs_;
}
void setNumberOfInputs(uint32_t value) {
  member_number_of_inputs_ = value;
}

bool hasNumberOfOutputs() const {
  return true;
}
uint32_t numberOfOutputs() const {
  return member_number_of_outputs_;
}
void setNumberOfOutputs(uint32_t value) {
  member_number_of_outputs_ = value;
}

bool hasOutputChannelCount() const {
  return has_output_channel_count_;
}
const Vector<uint32_t>& outputChannelCount() const {
  DCHECK(hasOutputChannelCount());
return member_output_channel_count_;
}
Vector<uint32_t> getOutputChannelCountOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getOutputChannelCountOr(Vector<uint32_t>&& fallback_value) const;
void setOutputChannelCount(const Vector<uint32_t>& value);
void setOutputChannelCount(Vector<uint32_t>&& value);

bool hasParameterData() const {
  return has_parameter_data_;
}
const Vector<std::pair<String, double>>& parameterData() const {
  DCHECK(hasParameterData());
return member_parameter_data_;
}
Vector<std::pair<String, double>> getParameterDataOr(const Vector<std::pair<String, double>>& fallback_value) const;
Vector<std::pair<String, double>> getParameterDataOr(Vector<std::pair<String, double>>&& fallback_value) const;
void setParameterData(const Vector<std::pair<String, double>>& value);
void setParameterData(Vector<std::pair<String, double>>&& value);

bool hasProcessorOptions() const {
  return has_processor_options_;
}
const ScriptObject& processorOptions() const {
  DCHECK(hasProcessorOptions());
return member_processor_options_;
}
ScriptObject getProcessorOptionsOr(const ScriptObject& fallback_value) const {
  if (!hasProcessorOptions()) {
  return fallback_value;
}
return member_processor_options_;
}
void setProcessorOptions(const ScriptObject& value) {
  member_processor_options_ = value;
has_processor_options_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = AudioNodeOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_output_channel_count_ = false;
bool has_parameter_data_ = false;
bool has_processor_options_ = false;

uint32_t member_number_of_inputs_{1};
uint32_t member_number_of_outputs_{1};
Vector<uint32_t> member_output_channel_count_;
Vector<std::pair<String, double>> member_parameter_data_;
ScriptObject member_processor_options_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_WORKLET_NODE_OPTIONS_H_
