// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_param_descriptor.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"automationRate",
"defaultValue",
"maxValue",
"minValue",
"name",
};


}  // namespace 

AudioParamDescriptor* AudioParamDescriptor::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AudioParamDescriptor* dictionary = MakeGarbageCollected<AudioParamDescriptor>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AudioParamDescriptor";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AudioParamDescriptor::AudioParamDescriptor() {
  
}

 AudioParamDescriptor::AudioParamDescriptor(v8::Isolate* isolate) {
  
}























void AudioParamDescriptor::setName(const String& value) {
  member_name_ = value;
}

void AudioParamDescriptor::setName(String&& value) {
  member_name_ = std::move(value);
}




void AudioParamDescriptor::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void AudioParamDescriptor::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void AudioParamDescriptor::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAutomationRate()) {
  values[0] = ToV8Traits<V8AutomationRate>::ToV8(script_state, member_automation_rate_);
DCHECK(!values[0].IsEmpty());
}
if (hasDefaultValue()) {
  values[1] = ToV8Traits<IDLFloat>::ToV8(script_state, member_default_value_);
DCHECK(!values[1].IsEmpty());
}
if (hasMaxValue()) {
  values[2] = ToV8Traits<IDLFloat>::ToV8(script_state, member_max_value_);
DCHECK(!values[2].IsEmpty());
}
if (hasMinValue()) {
  values[3] = ToV8Traits<IDLFloat>::ToV8(script_state, member_min_value_);
DCHECK(!values[3].IsEmpty());
}
if (hasName()) {
  values[4] = ToV8Traits<IDLString>::ToV8(script_state, member_name_);
DCHECK(!values[4].IsEmpty());
}
}

const void* AudioParamDescriptor::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> AudioParamDescriptor::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void AudioParamDescriptor::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AudioParamDescriptor";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("automationRate");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8AutomationRate, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_automation_rate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("defaultValue");
if (!bindings::GetDictionaryMemberFromV8Object<IDLFloat, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_default_value_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("maxValue");
if (!bindings::GetDictionaryMemberFromV8Object<IDLFloat, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_max_value_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("minValue");
if (!bindings::GetDictionaryMemberFromV8Object<IDLFloat, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_min_value_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("name");
constexpr bool is_required = true;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_name_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AudioParamDescriptor::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
