// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_NODE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_NODE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_channel_count_mode.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_channel_interpretation.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AudioNodeOptions : public bindings::DictionaryBase {
  
  public:
static AudioNodeOptions* Create() {
  return MakeGarbageCollected<AudioNodeOptions>();
}
static AudioNodeOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AudioNodeOptions>(isolate);
}
static AudioNodeOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AudioNodeOptions();
explicit  AudioNodeOptions(v8::Isolate* isolate);

bool hasChannelCount() const {
  return has_channel_count_;
}
uint32_t channelCount() const {
  DCHECK(hasChannelCount());
return member_channel_count_;
}
uint32_t getChannelCountOr(uint32_t fallback_value) const {
  if (!hasChannelCount()) {
  return fallback_value;
}
return member_channel_count_;
}
void setChannelCount(uint32_t value) {
  member_channel_count_ = value;
has_channel_count_ = true;
}

bool hasChannelCountMode() const {
  return has_channel_count_mode_;
}
V8ChannelCountMode channelCountMode() const {
  DCHECK(hasChannelCountMode());
return member_channel_count_mode_;
}
V8ChannelCountMode getChannelCountModeOr(V8ChannelCountMode fallback_value) const {
  if (!hasChannelCountMode()) {
  return fallback_value;
}
return member_channel_count_mode_;
}
void setChannelCountMode(V8ChannelCountMode value) {
  member_channel_count_mode_ = value;
has_channel_count_mode_ = true;
}
void setChannelCountMode(V8ChannelCountMode::Enum value) {
  member_channel_count_mode_ = V8ChannelCountMode(value);
has_channel_count_mode_ = true;
}

bool hasChannelInterpretation() const {
  return has_channel_interpretation_;
}
V8ChannelInterpretation channelInterpretation() const {
  DCHECK(hasChannelInterpretation());
return member_channel_interpretation_;
}
V8ChannelInterpretation getChannelInterpretationOr(V8ChannelInterpretation fallback_value) const {
  if (!hasChannelInterpretation()) {
  return fallback_value;
}
return member_channel_interpretation_;
}
void setChannelInterpretation(V8ChannelInterpretation value) {
  member_channel_interpretation_ = value;
has_channel_interpretation_ = true;
}
void setChannelInterpretation(V8ChannelInterpretation::Enum value) {
  member_channel_interpretation_ = V8ChannelInterpretation(value);
has_channel_interpretation_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_channel_count_ = false;
bool has_channel_count_mode_ = false;
bool has_channel_interpretation_ = false;

uint32_t member_channel_count_;
V8ChannelCountMode member_channel_count_mode_{static_cast<V8ChannelCountMode::Enum>(0)};
V8ChannelInterpretation member_channel_interpretation_{static_cast<V8ChannelInterpretation::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_NODE_OPTIONS_H_
