// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_ENCODER_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_ENCODER_CONFIG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_bitrate_mode.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AacEncoderConfig;
class ExceptionState;
class OpusEncoderConfig;

class MODULES_EXPORT AudioEncoderConfig : public bindings::DictionaryBase {
  
  public:
static AudioEncoderConfig* Create() {
  return MakeGarbageCollected<AudioEncoderConfig>();
}
static AudioEncoderConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AudioEncoderConfig>(isolate);
}
static AudioEncoderConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AudioEncoderConfig();
explicit  AudioEncoderConfig(v8::Isolate* isolate);

bool hasAac() const {
  return has_aac_;
}
AacEncoderConfig* aac() const {
  DCHECK(hasAac());
return member_aac_.Get();
}
AacEncoderConfig* getAacOr(AacEncoderConfig* fallback_value) const {
  if (!hasAac()) {
  return fallback_value;
}
return member_aac_.Get();
}
void setAac(AacEncoderConfig* value) {
  member_aac_ = value;
has_aac_ = true;
DCHECK(member_aac_);
}

bool hasBitrate() const {
  return has_bitrate_;
}
uint64_t bitrate() const {
  DCHECK(hasBitrate());
return member_bitrate_;
}
uint64_t getBitrateOr(uint64_t fallback_value) const {
  if (!hasBitrate()) {
  return fallback_value;
}
return member_bitrate_;
}
void setBitrate(uint64_t value) {
  member_bitrate_ = value;
has_bitrate_ = true;
}

bool hasBitrateMode() const {
  return true;
}
V8BitrateMode bitrateMode() const {
  return member_bitrate_mode_;
}
void setBitrateMode(V8BitrateMode value) {
  member_bitrate_mode_ = value;
}
void setBitrateMode(V8BitrateMode::Enum value) {
  member_bitrate_mode_ = V8BitrateMode(value);
}

bool hasCodec() const {
  return true;
}
const String& codec() const {
  return member_codec_;
}
void setCodec(const String& value);
void setCodec(String&& value);

bool hasNumberOfChannels() const {
  return true;
}
uint16_t numberOfChannels() const {
  return member_number_of_channels_;
}
void setNumberOfChannels(uint16_t value) {
  member_number_of_channels_ = value;
}

bool hasOpus() const {
  return has_opus_;
}
OpusEncoderConfig* opus() const {
  DCHECK(hasOpus());
return member_opus_.Get();
}
OpusEncoderConfig* getOpusOr(OpusEncoderConfig* fallback_value) const {
  if (!hasOpus()) {
  return fallback_value;
}
return member_opus_.Get();
}
void setOpus(OpusEncoderConfig* value) {
  member_opus_ = value;
has_opus_ = true;
DCHECK(member_opus_);
}

bool hasSampleRate() const {
  return true;
}
uint32_t sampleRate() const {
  return member_sample_rate_;
}
void setSampleRate(uint32_t value) {
  member_sample_rate_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_aac_ = false;
bool has_bitrate_ = false;
bool has_opus_ = false;

Member<AacEncoderConfig> member_aac_;
uint64_t member_bitrate_;
V8BitrateMode member_bitrate_mode_{V8BitrateMode::Enum::kVariable};
String member_codec_;
uint16_t member_number_of_channels_;
Member<OpusEncoderConfig> member_opus_;
uint32_t member_sample_rate_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_ENCODER_CONFIG_H_
