// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_encoder_config.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_aac_encoder_config.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_opus_encoder_config.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"aac",
"bitrate",
"bitrateMode",
"codec",
"numberOfChannels",
"opus",
"sampleRate",
};


}  // namespace 

AudioEncoderConfig* AudioEncoderConfig::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AudioEncoderConfig* dictionary = MakeGarbageCollected<AudioEncoderConfig>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AudioEncoderConfig";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AudioEncoderConfig::AudioEncoderConfig() {
  
}

 AudioEncoderConfig::AudioEncoderConfig(v8::Isolate* isolate) {
  
}






















void AudioEncoderConfig::setCodec(const String& value) {
  member_codec_ = value;
}

void AudioEncoderConfig::setCodec(String&& value) {
  member_codec_ = std::move(value);
}





















void AudioEncoderConfig::Trace(Visitor* visitor) const {
  visitor->Trace(member_aac_);
visitor->Trace(member_opus_);
bindings::DictionaryBase::Trace(visitor);
}

void AudioEncoderConfig::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void AudioEncoderConfig::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAac()) {
  values[0] = ToV8Traits<AacEncoderConfig>::ToV8(script_state, member_aac_.Get());
DCHECK(!values[0].IsEmpty());
}
if (hasBitrate()) {
  values[1] = ToV8Traits<IDLUnsignedLongLongEnforceRange>::ToV8(script_state, member_bitrate_);
DCHECK(!values[1].IsEmpty());
}
if (hasBitrateMode()) {
  values[2] = ToV8Traits<V8BitrateMode>::ToV8(script_state, member_bitrate_mode_);
DCHECK(!values[2].IsEmpty());
}
if (hasCodec()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_codec_);
DCHECK(!values[3].IsEmpty());
}
if (hasNumberOfChannels()) {
  values[4] = ToV8Traits<IDLUnsignedShortEnforceRange>::ToV8(script_state, member_number_of_channels_);
DCHECK(!values[4].IsEmpty());
}
if (hasOpus()) {
  values[5] = ToV8Traits<OpusEncoderConfig>::ToV8(script_state, member_opus_.Get());
DCHECK(!values[5].IsEmpty());
}
if (hasSampleRate()) {
  values[6] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_sample_rate_);
DCHECK(!values[6].IsEmpty());
}
}

const void* AudioEncoderConfig::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> AudioEncoderConfig::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void AudioEncoderConfig::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AudioEncoderConfig";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("aac");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<AacEncoderConfig, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_aac_, member_aac_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("bitrate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_bitrate_, member_bitrate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("bitrateMode");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8BitrateMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_bitrate_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("codec");
constexpr bool is_required = true;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_codec_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("numberOfChannels");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShortEnforceRange, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_number_of_channels_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("opus");
if (!bindings::GetDictionaryMemberFromV8Object<OpusEncoderConfig, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_opus_, member_opus_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sampleRate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_sample_rate_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AudioEncoderConfig::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
