// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_DATA_COPY_TO_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_DATA_COPY_TO_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_sample_format.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AudioDataCopyToOptions : public bindings::InputDictionaryBase {
  
  public:
static AudioDataCopyToOptions* Create() {
  return MakeGarbageCollected<AudioDataCopyToOptions>();
}
static AudioDataCopyToOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AudioDataCopyToOptions>(isolate);
}
static AudioDataCopyToOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AudioDataCopyToOptions();
explicit  AudioDataCopyToOptions(v8::Isolate* isolate);

bool hasFormat() const {
  return has_format_;
}
V8AudioSampleFormat format() const {
  DCHECK(hasFormat());
return member_format_;
}
V8AudioSampleFormat getFormatOr(V8AudioSampleFormat fallback_value) const {
  if (!hasFormat()) {
  return fallback_value;
}
return member_format_;
}
void setFormat(V8AudioSampleFormat value) {
  member_format_ = value;
has_format_ = true;
}
void setFormat(V8AudioSampleFormat::Enum value) {
  member_format_ = V8AudioSampleFormat(value);
has_format_ = true;
}

bool hasFrameCount() const {
  return has_frame_count_;
}
uint32_t frameCount() const {
  DCHECK(hasFrameCount());
return member_frame_count_;
}
uint32_t getFrameCountOr(uint32_t fallback_value) const {
  if (!hasFrameCount()) {
  return fallback_value;
}
return member_frame_count_;
}
void setFrameCount(uint32_t value) {
  member_frame_count_ = value;
has_frame_count_ = true;
}

bool hasFrameOffset() const {
  return true;
}
uint32_t frameOffset() const {
  return member_frame_offset_;
}
void setFrameOffset(uint32_t value) {
  member_frame_offset_ = value;
}

bool hasPlaneIndex() const {
  return true;
}
uint32_t planeIndex() const {
  return member_plane_index_;
}
void setPlaneIndex(uint32_t value) {
  member_plane_index_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_format_ = false;
bool has_frame_count_ = false;

V8AudioSampleFormat member_format_{static_cast<V8AudioSampleFormat::Enum>(0)};
uint32_t member_frame_count_;
uint32_t member_frame_offset_{0};
uint32_t member_plane_index_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_DATA_COPY_TO_OPTIONS_H_
