// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_CONFIGURATION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_CONFIGURATION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AudioConfiguration : public bindings::InputDictionaryBase {
  
  public:
static AudioConfiguration* Create() {
  return MakeGarbageCollected<AudioConfiguration>();
}
static AudioConfiguration* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AudioConfiguration>(isolate);
}
static AudioConfiguration* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AudioConfiguration();
explicit  AudioConfiguration(v8::Isolate* isolate);

bool hasBitrate() const {
  return has_bitrate_;
}
uint32_t bitrate() const {
  DCHECK(hasBitrate());
return member_bitrate_;
}
uint32_t getBitrateOr(uint32_t fallback_value) const {
  if (!hasBitrate()) {
  return fallback_value;
}
return member_bitrate_;
}
void setBitrate(uint32_t value) {
  member_bitrate_ = value;
has_bitrate_ = true;
}

bool hasChannels() const {
  return has_channels_;
}
const String& channels() const {
  DCHECK(hasChannels());
return member_channels_;
}
String getChannelsOr(const String& fallback_value) const;
String getChannelsOr(String&& fallback_value) const;
void setChannels(const String& value);
void setChannels(String&& value);

bool hasContentType() const {
  return true;
}
const String& contentType() const {
  return member_content_type_;
}
void setContentType(const String& value);
void setContentType(String&& value);

bool hasSamplerate() const {
  return has_samplerate_;
}
uint32_t samplerate() const {
  DCHECK(hasSamplerate());
return member_samplerate_;
}
uint32_t getSamplerateOr(uint32_t fallback_value) const {
  if (!hasSamplerate()) {
  return fallback_value;
}
return member_samplerate_;
}
void setSamplerate(uint32_t value) {
  member_samplerate_ = value;
has_samplerate_ = true;
}

bool hasSpatialRendering() const {
  return has_spatial_rendering_;
}
bool spatialRendering() const {
  DCHECK(hasSpatialRendering());
return member_spatial_rendering_;
}
bool getSpatialRenderingOr(bool fallback_value) const {
  if (!hasSpatialRendering()) {
  return fallback_value;
}
return member_spatial_rendering_;
}
void setSpatialRendering(bool value) {
  member_spatial_rendering_ = value;
has_spatial_rendering_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_bitrate_ = false;
bool has_channels_ = false;
bool has_samplerate_ = false;
bool has_spatial_rendering_ = false;

uint32_t member_bitrate_;
String member_channels_;
String member_content_type_;
uint32_t member_samplerate_;
bool member_spatial_rendering_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_CONFIGURATION_H_
