// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_BUFFER_SOURCE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_BUFFER_SOURCE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AudioBuffer;
class ExceptionState;

class MODULES_EXPORT AudioBufferSourceOptions : public bindings::InputDictionaryBase {
  
  public:
static AudioBufferSourceOptions* Create() {
  return MakeGarbageCollected<AudioBufferSourceOptions>();
}
static AudioBufferSourceOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AudioBufferSourceOptions>(isolate);
}
static AudioBufferSourceOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AudioBufferSourceOptions();
explicit  AudioBufferSourceOptions(v8::Isolate* isolate);

bool hasBuffer() const {
  return has_buffer_;
}
AudioBuffer* buffer() const {
  DCHECK(hasBuffer());
return member_buffer_.Get();
}
AudioBuffer* getBufferOr(AudioBuffer* fallback_value) const {
  if (!hasBuffer()) {
  return fallback_value;
}
return member_buffer_.Get();
}
void setBuffer(AudioBuffer* value) {
  member_buffer_ = value;
has_buffer_ = true;
}

bool hasDetune() const {
  return true;
}
float detune() const {
  return member_detune_;
}
void setDetune(float value) {
  member_detune_ = value;
}

bool hasLoop() const {
  return true;
}
bool loop() const {
  return member_loop_;
}
void setLoop(bool value) {
  member_loop_ = value;
}

bool hasLoopEnd() const {
  return true;
}
double loopEnd() const {
  return member_loop_end_;
}
void setLoopEnd(double value) {
  member_loop_end_ = value;
}

bool hasLoopStart() const {
  return true;
}
double loopStart() const {
  return member_loop_start_;
}
void setLoopStart(double value) {
  member_loop_start_ = value;
}

bool hasPlaybackRate() const {
  return true;
}
float playbackRate() const {
  return member_playback_rate_;
}
void setPlaybackRate(float value) {
  member_playback_rate_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_buffer_ = false;

Member<AudioBuffer> member_buffer_;
float member_detune_{0};
bool member_loop_{false};
double member_loop_end_{0};
double member_loop_start_{0};
float member_playback_rate_{1};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_BUFFER_SOURCE_OPTIONS_H_
