// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUCTION_AD_INTEREST_GROUP_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUCTION_AD_INTEREST_GROUP_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AuctionAd;
class AuctionAdInterestGroupSize;
class ExceptionState;
class ProtectedAudiencePrivateAggregationConfig;

class MODULES_EXPORT AuctionAdInterestGroup : public bindings::DictionaryBase {
  
  public:
static AuctionAdInterestGroup* Create() {
  return MakeGarbageCollected<AuctionAdInterestGroup>();
}
static AuctionAdInterestGroup* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuctionAdInterestGroup>(isolate);
}
static AuctionAdInterestGroup* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuctionAdInterestGroup();
explicit  AuctionAdInterestGroup(v8::Isolate* isolate);

bool hasAdComponents() const {
  return has_ad_components_;
}
const HeapVector<Member<AuctionAd>>& adComponents() const {
  DCHECK(hasAdComponents());
return member_ad_components_;
}
HeapVector<Member<AuctionAd>> getAdComponentsOr(const HeapVector<Member<AuctionAd>>& fallback_value) const;
HeapVector<Member<AuctionAd>> getAdComponentsOr(HeapVector<Member<AuctionAd>>&& fallback_value) const;
void setAdComponents(const HeapVector<Member<AuctionAd>>& value);
void setAdComponents(HeapVector<Member<AuctionAd>>&& value);

bool hasAdSizes() const {
  return has_ad_sizes_;
}
const HeapVector<std::pair<String, Member<AuctionAdInterestGroupSize>>>& adSizes() const {
  DCHECK(hasAdSizes());
return member_ad_sizes_;
}
HeapVector<std::pair<String, Member<AuctionAdInterestGroupSize>>> getAdSizesOr(const HeapVector<std::pair<String, Member<AuctionAdInterestGroupSize>>>& fallback_value) const;
HeapVector<std::pair<String, Member<AuctionAdInterestGroupSize>>> getAdSizesOr(HeapVector<std::pair<String, Member<AuctionAdInterestGroupSize>>>&& fallback_value) const;
void setAdSizes(const HeapVector<std::pair<String, Member<AuctionAdInterestGroupSize>>>& value);
void setAdSizes(HeapVector<std::pair<String, Member<AuctionAdInterestGroupSize>>>&& value);

bool hasAdditionalBidKey() const {
  return has_additional_bid_key_;
}
const String& additionalBidKey() const {
  DCHECK(hasAdditionalBidKey());
return member_additional_bid_key_;
}
String getAdditionalBidKeyOr(const String& fallback_value) const;
String getAdditionalBidKeyOr(String&& fallback_value) const;
void setAdditionalBidKey(const String& value);
void setAdditionalBidKey(String&& value);

bool hasAds() const {
  return has_ads_;
}
const HeapVector<Member<AuctionAd>>& ads() const {
  DCHECK(hasAds());
return member_ads_;
}
HeapVector<Member<AuctionAd>> getAdsOr(const HeapVector<Member<AuctionAd>>& fallback_value) const;
HeapVector<Member<AuctionAd>> getAdsOr(HeapVector<Member<AuctionAd>>&& fallback_value) const;
void setAds(const HeapVector<Member<AuctionAd>>& value);
void setAds(HeapVector<Member<AuctionAd>>&& value);

bool hasAuctionServerRequestFlags() const {
  return has_auction_server_request_flags_;
}
const Vector<String>& auctionServerRequestFlags() const {
  DCHECK(hasAuctionServerRequestFlags());
return member_auction_server_request_flags_;
}
Vector<String> getAuctionServerRequestFlagsOr(const Vector<String>& fallback_value) const;
Vector<String> getAuctionServerRequestFlagsOr(Vector<String>&& fallback_value) const;
void setAuctionServerRequestFlags(const Vector<String>& value);
void setAuctionServerRequestFlags(Vector<String>&& value);

bool hasBiddingLogicURL() const {
  return has_bidding_logic_url_;
}
const String& biddingLogicURL() const {
  DCHECK(hasBiddingLogicURL());
return member_bidding_logic_url_;
}
String getBiddingLogicURLOr(const String& fallback_value) const;
String getBiddingLogicURLOr(String&& fallback_value) const;
void setBiddingLogicURL(const String& value);
void setBiddingLogicURL(String&& value);

bool hasBiddingLogicUrlDeprecated() const {
  return has_bidding_logic_url_deprecated_;
}
const String& biddingLogicUrlDeprecated() const {
  DCHECK(hasBiddingLogicUrlDeprecated());
return member_bidding_logic_url_deprecated_;
}
String getBiddingLogicUrlDeprecatedOr(const String& fallback_value) const;
String getBiddingLogicUrlDeprecatedOr(String&& fallback_value) const;
void setBiddingLogicUrlDeprecated(const String& value);
void setBiddingLogicUrlDeprecated(String&& value);

bool hasBiddingWasmHelperURL() const {
  return has_bidding_wasm_helper_url_;
}
const String& biddingWasmHelperURL() const {
  DCHECK(hasBiddingWasmHelperURL());
return member_bidding_wasm_helper_url_;
}
String getBiddingWasmHelperURLOr(const String& fallback_value) const;
String getBiddingWasmHelperURLOr(String&& fallback_value) const;
void setBiddingWasmHelperURL(const String& value);
void setBiddingWasmHelperURL(String&& value);

bool hasBiddingWasmHelperUrlDeprecated() const {
  return has_bidding_wasm_helper_url_deprecated_;
}
const String& biddingWasmHelperUrlDeprecated() const {
  DCHECK(hasBiddingWasmHelperUrlDeprecated());
return member_bidding_wasm_helper_url_deprecated_;
}
String getBiddingWasmHelperUrlDeprecatedOr(const String& fallback_value) const;
String getBiddingWasmHelperUrlDeprecatedOr(String&& fallback_value) const;
void setBiddingWasmHelperUrlDeprecated(const String& value);
void setBiddingWasmHelperUrlDeprecated(String&& value);

bool hasDailyUpdateUrl() const {
  return has_daily_update_url_;
}
const String& dailyUpdateUrl() const {
  DCHECK(hasDailyUpdateUrl());
return member_daily_update_url_;
}
String getDailyUpdateUrlOr(const String& fallback_value) const;
String getDailyUpdateUrlOr(String&& fallback_value) const;
void setDailyUpdateUrl(const String& value);
void setDailyUpdateUrl(String&& value);

bool hasEnableBiddingSignalsPrioritization() const {
  return has_enable_bidding_signals_prioritization_;
}
bool enableBiddingSignalsPrioritization() const {
  DCHECK(hasEnableBiddingSignalsPrioritization());
return member_enable_bidding_signals_prioritization_;
}
bool getEnableBiddingSignalsPrioritizationOr(bool fallback_value) const {
  if (!hasEnableBiddingSignalsPrioritization()) {
  return fallback_value;
}
return member_enable_bidding_signals_prioritization_;
}
void setEnableBiddingSignalsPrioritization(bool value) {
  member_enable_bidding_signals_prioritization_ = value;
has_enable_bidding_signals_prioritization_ = true;
}

bool hasExecutionMode() const {
  return has_execution_mode_;
}
const String& executionMode() const {
  DCHECK(hasExecutionMode());
return member_execution_mode_;
}
String getExecutionModeOr(const String& fallback_value) const;
String getExecutionModeOr(String&& fallback_value) const;
void setExecutionMode(const String& value);
void setExecutionMode(String&& value);

bool hasLifetimeMs() const {
  return has_lifetime_ms_;
}
double lifetimeMs() const {
  DCHECK(hasLifetimeMs());
return member_lifetime_ms_;
}
double getLifetimeMsOr(double fallback_value) const {
  if (!hasLifetimeMs()) {
  return fallback_value;
}
return member_lifetime_ms_;
}
void setLifetimeMs(double value) {
  member_lifetime_ms_ = value;
has_lifetime_ms_ = true;
}

bool hasMaxTrustedBiddingSignalsURLLength() const {
  return has_max_trusted_bidding_signals_url_length_;
}
int32_t maxTrustedBiddingSignalsURLLength() const {
  DCHECK(hasMaxTrustedBiddingSignalsURLLength());
return member_max_trusted_bidding_signals_url_length_;
}
int32_t getMaxTrustedBiddingSignalsURLLengthOr(int32_t fallback_value) const {
  if (!hasMaxTrustedBiddingSignalsURLLength()) {
  return fallback_value;
}
return member_max_trusted_bidding_signals_url_length_;
}
void setMaxTrustedBiddingSignalsURLLength(int32_t value) {
  member_max_trusted_bidding_signals_url_length_ = value;
has_max_trusted_bidding_signals_url_length_ = true;
}

bool hasName() const {
  return true;
}
const String& name() const {
  return member_name_;
}
void setName(const String& value);
void setName(String&& value);

bool hasOwner() const {
  return true;
}
const String& owner() const {
  return member_owner_;
}
void setOwner(const String& value);
void setOwner(String&& value);

bool hasPriority() const {
  return has_priority_;
}
double priority() const {
  DCHECK(hasPriority());
return member_priority_;
}
double getPriorityOr(double fallback_value) const {
  if (!hasPriority()) {
  return fallback_value;
}
return member_priority_;
}
void setPriority(double value) {
  member_priority_ = value;
has_priority_ = true;
}

bool hasPrioritySignalsOverrides() const {
  return has_priority_signals_overrides_;
}
const Vector<std::pair<String, double>>& prioritySignalsOverrides() const {
  DCHECK(hasPrioritySignalsOverrides());
return member_priority_signals_overrides_;
}
Vector<std::pair<String, double>> getPrioritySignalsOverridesOr(const Vector<std::pair<String, double>>& fallback_value) const;
Vector<std::pair<String, double>> getPrioritySignalsOverridesOr(Vector<std::pair<String, double>>&& fallback_value) const;
void setPrioritySignalsOverrides(const Vector<std::pair<String, double>>& value);
void setPrioritySignalsOverrides(Vector<std::pair<String, double>>&& value);

bool hasPriorityVector() const {
  return has_priority_vector_;
}
const Vector<std::pair<String, double>>& priorityVector() const {
  DCHECK(hasPriorityVector());
return member_priority_vector_;
}
Vector<std::pair<String, double>> getPriorityVectorOr(const Vector<std::pair<String, double>>& fallback_value) const;
Vector<std::pair<String, double>> getPriorityVectorOr(Vector<std::pair<String, double>>&& fallback_value) const;
void setPriorityVector(const Vector<std::pair<String, double>>& value);
void setPriorityVector(Vector<std::pair<String, double>>&& value);

bool hasPrivateAggregationConfig() const {
  return has_private_aggregation_config_;
}
ProtectedAudiencePrivateAggregationConfig* privateAggregationConfig() const {
  DCHECK(hasPrivateAggregationConfig());
return member_private_aggregation_config_.Get();
}
ProtectedAudiencePrivateAggregationConfig* getPrivateAggregationConfigOr(ProtectedAudiencePrivateAggregationConfig* fallback_value) const {
  if (!hasPrivateAggregationConfig()) {
  return fallback_value;
}
return member_private_aggregation_config_.Get();
}
void setPrivateAggregationConfig(ProtectedAudiencePrivateAggregationConfig* value) {
  member_private_aggregation_config_ = value;
has_private_aggregation_config_ = true;
DCHECK(member_private_aggregation_config_);
}

bool hasSellerCapabilities() const {
  return has_seller_capabilities_;
}
const Vector<std::pair<String, Vector<String>>>& sellerCapabilities() const {
  DCHECK(hasSellerCapabilities());
return member_seller_capabilities_;
}
Vector<std::pair<String, Vector<String>>> getSellerCapabilitiesOr(const Vector<std::pair<String, Vector<String>>>& fallback_value) const;
Vector<std::pair<String, Vector<String>>> getSellerCapabilitiesOr(Vector<std::pair<String, Vector<String>>>&& fallback_value) const;
void setSellerCapabilities(const Vector<std::pair<String, Vector<String>>>& value);
void setSellerCapabilities(Vector<std::pair<String, Vector<String>>>&& value);

bool hasSizeGroups() const {
  return has_size_groups_;
}
const Vector<std::pair<String, Vector<String>>>& sizeGroups() const {
  DCHECK(hasSizeGroups());
return member_size_groups_;
}
Vector<std::pair<String, Vector<String>>> getSizeGroupsOr(const Vector<std::pair<String, Vector<String>>>& fallback_value) const;
Vector<std::pair<String, Vector<String>>> getSizeGroupsOr(Vector<std::pair<String, Vector<String>>>&& fallback_value) const;
void setSizeGroups(const Vector<std::pair<String, Vector<String>>>& value);
void setSizeGroups(Vector<std::pair<String, Vector<String>>>&& value);

bool hasTrustedBiddingSignalsCoordinator() const {
  return has_trusted_bidding_signals_coordinator_;
}
const String& trustedBiddingSignalsCoordinator() const {
  DCHECK(hasTrustedBiddingSignalsCoordinator());
return member_trusted_bidding_signals_coordinator_;
}
String getTrustedBiddingSignalsCoordinatorOr(const String& fallback_value) const;
String getTrustedBiddingSignalsCoordinatorOr(String&& fallback_value) const;
void setTrustedBiddingSignalsCoordinator(const String& value);
void setTrustedBiddingSignalsCoordinator(String&& value);

bool hasTrustedBiddingSignalsKeys() const {
  return has_trusted_bidding_signals_keys_;
}
const Vector<String>& trustedBiddingSignalsKeys() const {
  DCHECK(hasTrustedBiddingSignalsKeys());
return member_trusted_bidding_signals_keys_;
}
Vector<String> getTrustedBiddingSignalsKeysOr(const Vector<String>& fallback_value) const;
Vector<String> getTrustedBiddingSignalsKeysOr(Vector<String>&& fallback_value) const;
void setTrustedBiddingSignalsKeys(const Vector<String>& value);
void setTrustedBiddingSignalsKeys(Vector<String>&& value);

bool hasTrustedBiddingSignalsSlotSizeMode() const {
  return has_trusted_bidding_signals_slot_size_mode_;
}
const String& trustedBiddingSignalsSlotSizeMode() const {
  DCHECK(hasTrustedBiddingSignalsSlotSizeMode());
return member_trusted_bidding_signals_slot_size_mode_;
}
String getTrustedBiddingSignalsSlotSizeModeOr(const String& fallback_value) const;
String getTrustedBiddingSignalsSlotSizeModeOr(String&& fallback_value) const;
void setTrustedBiddingSignalsSlotSizeMode(const String& value);
void setTrustedBiddingSignalsSlotSizeMode(String&& value);

bool hasTrustedBiddingSignalsURL() const {
  return has_trusted_bidding_signals_url_;
}
const String& trustedBiddingSignalsURL() const {
  DCHECK(hasTrustedBiddingSignalsURL());
return member_trusted_bidding_signals_url_;
}
String getTrustedBiddingSignalsURLOr(const String& fallback_value) const;
String getTrustedBiddingSignalsURLOr(String&& fallback_value) const;
void setTrustedBiddingSignalsURL(const String& value);
void setTrustedBiddingSignalsURL(String&& value);

bool hasTrustedBiddingSignalsUrlDeprecated() const {
  return has_trusted_bidding_signals_url_deprecated_;
}
const String& trustedBiddingSignalsUrlDeprecated() const {
  DCHECK(hasTrustedBiddingSignalsUrlDeprecated());
return member_trusted_bidding_signals_url_deprecated_;
}
String getTrustedBiddingSignalsUrlDeprecatedOr(const String& fallback_value) const;
String getTrustedBiddingSignalsUrlDeprecatedOr(String&& fallback_value) const;
void setTrustedBiddingSignalsUrlDeprecated(const String& value);
void setTrustedBiddingSignalsUrlDeprecated(String&& value);

bool hasUpdateURL() const {
  return has_update_url_;
}
const String& updateURL() const {
  DCHECK(hasUpdateURL());
return member_update_url_;
}
String getUpdateURLOr(const String& fallback_value) const;
String getUpdateURLOr(String&& fallback_value) const;
void setUpdateURL(const String& value);
void setUpdateURL(String&& value);

bool hasUpdateUrlDeprecated() const {
  return has_update_url_deprecated_;
}
const String& updateUrlDeprecated() const {
  DCHECK(hasUpdateUrlDeprecated());
return member_update_url_deprecated_;
}
String getUpdateUrlDeprecatedOr(const String& fallback_value) const;
String getUpdateUrlDeprecatedOr(String&& fallback_value) const;
void setUpdateUrlDeprecated(const String& value);
void setUpdateUrlDeprecated(String&& value);

bool hasUserBiddingSignals() const {
  return !member_user_bidding_signals_.IsEmpty();
}
const ScriptValue& userBiddingSignals() const {
  DCHECK(hasUserBiddingSignals());
return member_user_bidding_signals_;
}
ScriptValue getUserBiddingSignalsOr(const ScriptValue& fallback_value) const {
  if (!hasUserBiddingSignals()) {
  return fallback_value;
}
return member_user_bidding_signals_;
}
void setUserBiddingSignals(const ScriptValue& value) {
  member_user_bidding_signals_ = value;
}

bool hasViewAndClickCountsProviders() const {
  return has_view_and_click_counts_providers_;
}
const Vector<String>& viewAndClickCountsProviders() const {
  DCHECK(hasViewAndClickCountsProviders());
return member_view_and_click_counts_providers_;
}
Vector<String> getViewAndClickCountsProvidersOr(const Vector<String>& fallback_value) const;
Vector<String> getViewAndClickCountsProvidersOr(Vector<String>&& fallback_value) const;
void setViewAndClickCountsProviders(const Vector<String>& value);
void setViewAndClickCountsProviders(Vector<String>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 31;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_ad_components_ = false;
bool has_ad_sizes_ = false;
bool has_additional_bid_key_ = false;
bool has_ads_ = false;
bool has_auction_server_request_flags_ = false;
bool has_bidding_logic_url_ = false;
bool has_bidding_logic_url_deprecated_ = false;
bool has_bidding_wasm_helper_url_ = false;
bool has_bidding_wasm_helper_url_deprecated_ = false;
bool has_daily_update_url_ = false;
bool has_enable_bidding_signals_prioritization_ = false;
bool has_execution_mode_ = false;
bool has_lifetime_ms_ = false;
bool has_max_trusted_bidding_signals_url_length_ = false;
bool has_priority_ = false;
bool has_priority_signals_overrides_ = false;
bool has_priority_vector_ = false;
bool has_private_aggregation_config_ = false;
bool has_seller_capabilities_ = false;
bool has_size_groups_ = false;
bool has_trusted_bidding_signals_coordinator_ = false;
bool has_trusted_bidding_signals_keys_ = false;
bool has_trusted_bidding_signals_slot_size_mode_ = false;
bool has_trusted_bidding_signals_url_ = false;
bool has_trusted_bidding_signals_url_deprecated_ = false;
bool has_update_url_ = false;
bool has_update_url_deprecated_ = false;
bool has_view_and_click_counts_providers_ = false;

HeapVector<Member<AuctionAd>> member_ad_components_;
HeapVector<std::pair<String, Member<AuctionAdInterestGroupSize>>> member_ad_sizes_;
String member_additional_bid_key_;
HeapVector<Member<AuctionAd>> member_ads_;
Vector<String> member_auction_server_request_flags_;
String member_bidding_logic_url_;
String member_bidding_logic_url_deprecated_;
String member_bidding_wasm_helper_url_;
String member_bidding_wasm_helper_url_deprecated_;
String member_daily_update_url_;
bool member_enable_bidding_signals_prioritization_;
String member_execution_mode_;
double member_lifetime_ms_;
int32_t member_max_trusted_bidding_signals_url_length_;
String member_name_;
String member_owner_;
double member_priority_;
Vector<std::pair<String, double>> member_priority_signals_overrides_;
Vector<std::pair<String, double>> member_priority_vector_;
Member<ProtectedAudiencePrivateAggregationConfig> member_private_aggregation_config_;
Vector<std::pair<String, Vector<String>>> member_seller_capabilities_;
Vector<std::pair<String, Vector<String>>> member_size_groups_;
String member_trusted_bidding_signals_coordinator_;
Vector<String> member_trusted_bidding_signals_keys_;
String member_trusted_bidding_signals_slot_size_mode_;
String member_trusted_bidding_signals_url_;
String member_trusted_bidding_signals_url_deprecated_;
String member_update_url_;
String member_update_url_deprecated_;
ScriptValue member_user_bidding_signals_;
Vector<String> member_view_and_click_counts_providers_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUCTION_AD_INTEREST_GROUP_H_
