// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUCTION_AD_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUCTION_AD_CONFIG_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/script_promise.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/bigint.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AbortSignal;
class AuctionAdConfig;
class AuctionAdInterestGroupSize;
class AuctionRealTimeReportingConfig;
class AuctionReportBuyerDebugModeConfig;
class AuctionReportBuyersConfig;
class ExceptionState;
class ProtectedAudiencePrivateAggregationConfig;

class MODULES_EXPORT AuctionAdConfig : public bindings::InputDictionaryBase {
  
  public:
static AuctionAdConfig* Create() {
  return MakeGarbageCollected<AuctionAdConfig>();
}
static AuctionAdConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuctionAdConfig>(isolate);
}
static AuctionAdConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuctionAdConfig();
explicit  AuctionAdConfig(v8::Isolate* isolate);

bool hasAdditionalBids() const {
  return !member_additional_bids_.IsEmpty();
}
const MemberScriptPromise<IDLUndefined>& additionalBids() const {
  DCHECK(hasAdditionalBids());
return member_additional_bids_;
}
ScriptPromise<IDLUndefined> getAdditionalBidsOr(const MemberScriptPromise<IDLUndefined>& fallback_value) const {
  if (!hasAdditionalBids()) {
  return fallback_value;
}
return member_additional_bids_;
}
void setAdditionalBids(const MemberScriptPromise<IDLUndefined>& value) {
  member_additional_bids_ = value;
}

bool hasAllSlotsRequestedSizes() const {
  return has_all_slots_requested_sizes_;
}
const HeapVector<Member<AuctionAdInterestGroupSize>>& allSlotsRequestedSizes() const {
  DCHECK(hasAllSlotsRequestedSizes());
return member_all_slots_requested_sizes_;
}
HeapVector<Member<AuctionAdInterestGroupSize>> getAllSlotsRequestedSizesOr(const HeapVector<Member<AuctionAdInterestGroupSize>>& fallback_value) const;
HeapVector<Member<AuctionAdInterestGroupSize>> getAllSlotsRequestedSizesOr(HeapVector<Member<AuctionAdInterestGroupSize>>&& fallback_value) const;
void setAllSlotsRequestedSizes(const HeapVector<Member<AuctionAdInterestGroupSize>>& value);
void setAllSlotsRequestedSizes(HeapVector<Member<AuctionAdInterestGroupSize>>&& value);

bool hasAuctionNonce() const {
  return has_auction_nonce_;
}
const String& auctionNonce() const {
  DCHECK(hasAuctionNonce());
return member_auction_nonce_;
}
String getAuctionNonceOr(const String& fallback_value) const;
String getAuctionNonceOr(String&& fallback_value) const;
void setAuctionNonce(const String& value);
void setAuctionNonce(String&& value);

bool hasAuctionReportBuyerDebugModeConfig() const {
  return has_auction_report_buyer_debug_mode_config_;
}
AuctionReportBuyerDebugModeConfig* auctionReportBuyerDebugModeConfig() const {
  DCHECK(hasAuctionReportBuyerDebugModeConfig());
return member_auction_report_buyer_debug_mode_config_.Get();
}
AuctionReportBuyerDebugModeConfig* getAuctionReportBuyerDebugModeConfigOr(AuctionReportBuyerDebugModeConfig* fallback_value) const {
  if (!hasAuctionReportBuyerDebugModeConfig()) {
  return fallback_value;
}
return member_auction_report_buyer_debug_mode_config_.Get();
}
void setAuctionReportBuyerDebugModeConfig(AuctionReportBuyerDebugModeConfig* value) {
  member_auction_report_buyer_debug_mode_config_ = value;
has_auction_report_buyer_debug_mode_config_ = true;
DCHECK(member_auction_report_buyer_debug_mode_config_);
}

bool hasAuctionReportBuyerKeys() const {
  return has_auction_report_buyer_keys_;
}
const Vector<BigInt>& auctionReportBuyerKeys() const {
  DCHECK(hasAuctionReportBuyerKeys());
return member_auction_report_buyer_keys_;
}
Vector<BigInt> getAuctionReportBuyerKeysOr(const Vector<BigInt>& fallback_value) const;
Vector<BigInt> getAuctionReportBuyerKeysOr(Vector<BigInt>&& fallback_value) const;
void setAuctionReportBuyerKeys(const Vector<BigInt>& value);
void setAuctionReportBuyerKeys(Vector<BigInt>&& value);

bool hasAuctionReportBuyers() const {
  return has_auction_report_buyers_;
}
const HeapVector<std::pair<String, Member<AuctionReportBuyersConfig>>>& auctionReportBuyers() const {
  DCHECK(hasAuctionReportBuyers());
return member_auction_report_buyers_;
}
HeapVector<std::pair<String, Member<AuctionReportBuyersConfig>>> getAuctionReportBuyersOr(const HeapVector<std::pair<String, Member<AuctionReportBuyersConfig>>>& fallback_value) const;
HeapVector<std::pair<String, Member<AuctionReportBuyersConfig>>> getAuctionReportBuyersOr(HeapVector<std::pair<String, Member<AuctionReportBuyersConfig>>>&& fallback_value) const;
void setAuctionReportBuyers(const HeapVector<std::pair<String, Member<AuctionReportBuyersConfig>>>& value);
void setAuctionReportBuyers(HeapVector<std::pair<String, Member<AuctionReportBuyersConfig>>>&& value);

bool hasAuctionSignals() const {
  return !member_auction_signals_.IsEmpty();
}
const MemberScriptPromise<IDLAny>& auctionSignals() const {
  DCHECK(hasAuctionSignals());
return member_auction_signals_;
}
ScriptPromise<IDLAny> getAuctionSignalsOr(const MemberScriptPromise<IDLAny>& fallback_value) const {
  if (!hasAuctionSignals()) {
  return fallback_value;
}
return member_auction_signals_;
}
void setAuctionSignals(const MemberScriptPromise<IDLAny>& value) {
  member_auction_signals_ = value;
}

bool hasComponentAuctions() const {
  return has_component_auctions_;
}
const HeapVector<Member<AuctionAdConfig>>& componentAuctions() const {
  DCHECK(hasComponentAuctions());
return member_component_auctions_;
}
HeapVector<Member<AuctionAdConfig>> getComponentAuctionsOr(const HeapVector<Member<AuctionAdConfig>>& fallback_value) const;
HeapVector<Member<AuctionAdConfig>> getComponentAuctionsOr(HeapVector<Member<AuctionAdConfig>>&& fallback_value) const;
void setComponentAuctions(const HeapVector<Member<AuctionAdConfig>>& value);
void setComponentAuctions(HeapVector<Member<AuctionAdConfig>>&& value);

bool hasDecisionLogicURL() const {
  return has_decision_logic_url_;
}
const String& decisionLogicURL() const {
  DCHECK(hasDecisionLogicURL());
return member_decision_logic_url_;
}
String getDecisionLogicURLOr(const String& fallback_value) const;
String getDecisionLogicURLOr(String&& fallback_value) const;
void setDecisionLogicURL(const String& value);
void setDecisionLogicURL(String&& value);

bool hasDecisionLogicUrlDeprecated() const {
  return has_decision_logic_url_deprecated_;
}
const String& decisionLogicUrlDeprecated() const {
  DCHECK(hasDecisionLogicUrlDeprecated());
return member_decision_logic_url_deprecated_;
}
String getDecisionLogicUrlDeprecatedOr(const String& fallback_value) const;
String getDecisionLogicUrlDeprecatedOr(String&& fallback_value) const;
void setDecisionLogicUrlDeprecated(const String& value);
void setDecisionLogicUrlDeprecated(String&& value);

bool hasDeprecatedRenderURLReplacements() const {
  return !member_deprecated_render_url_replacements_.IsEmpty();
}
const MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUSVString>>>& deprecatedRenderURLReplacements() const {
  DCHECK(hasDeprecatedRenderURLReplacements());
return member_deprecated_render_url_replacements_;
}
ScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUSVString>>> getDeprecatedRenderURLReplacementsOr(const MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUSVString>>>& fallback_value) const {
  if (!hasDeprecatedRenderURLReplacements()) {
  return fallback_value;
}
return member_deprecated_render_url_replacements_;
}
void setDeprecatedRenderURLReplacements(const MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUSVString>>>& value) {
  member_deprecated_render_url_replacements_ = value;
}

bool hasDirectFromSellerSignals() const {
  return !member_direct_from_seller_signals_.IsEmpty();
}
const MemberScriptPromise<IDLNullable<IDLUSVString>>& directFromSellerSignals() const {
  DCHECK(hasDirectFromSellerSignals());
return member_direct_from_seller_signals_;
}
ScriptPromise<IDLNullable<IDLUSVString>> getDirectFromSellerSignalsOr(const MemberScriptPromise<IDLNullable<IDLUSVString>>& fallback_value) const {
  if (!hasDirectFromSellerSignals()) {
  return fallback_value;
}
return member_direct_from_seller_signals_;
}
void setDirectFromSellerSignals(const MemberScriptPromise<IDLNullable<IDLUSVString>>& value) {
  member_direct_from_seller_signals_ = value;
}

bool hasDirectFromSellerSignalsHeaderAdSlot() const {
  return !member_direct_from_seller_signals_header_ad_slot_.IsEmpty();
}
const MemberScriptPromise<IDLNullable<IDLString>>& directFromSellerSignalsHeaderAdSlot() const {
  DCHECK(hasDirectFromSellerSignalsHeaderAdSlot());
return member_direct_from_seller_signals_header_ad_slot_;
}
ScriptPromise<IDLNullable<IDLString>> getDirectFromSellerSignalsHeaderAdSlotOr(const MemberScriptPromise<IDLNullable<IDLString>>& fallback_value) const {
  if (!hasDirectFromSellerSignalsHeaderAdSlot()) {
  return fallback_value;
}
return member_direct_from_seller_signals_header_ad_slot_;
}
void setDirectFromSellerSignalsHeaderAdSlot(const MemberScriptPromise<IDLNullable<IDLString>>& value) {
  member_direct_from_seller_signals_header_ad_slot_ = value;
}

bool hasExecutionMode() const {
  return has_execution_mode_;
}
const String& executionMode() const {
  DCHECK(hasExecutionMode());
return member_execution_mode_;
}
String getExecutionModeOr(const String& fallback_value) const;
String getExecutionModeOr(String&& fallback_value) const;
void setExecutionMode(const String& value);
void setExecutionMode(String&& value);

bool hasInterestGroupBuyers() const {
  return has_interest_group_buyers_;
}
const Vector<String>& interestGroupBuyers() const {
  DCHECK(hasInterestGroupBuyers());
return member_interest_group_buyers_;
}
Vector<String> getInterestGroupBuyersOr(const Vector<String>& fallback_value) const;
Vector<String> getInterestGroupBuyersOr(Vector<String>&& fallback_value) const;
void setInterestGroupBuyers(const Vector<String>& value);
void setInterestGroupBuyers(Vector<String>&& value);

bool hasMaxTrustedScoringSignalsURLLength() const {
  return has_max_trusted_scoring_signals_url_length_;
}
int32_t maxTrustedScoringSignalsURLLength() const {
  DCHECK(hasMaxTrustedScoringSignalsURLLength());
return member_max_trusted_scoring_signals_url_length_;
}
int32_t getMaxTrustedScoringSignalsURLLengthOr(int32_t fallback_value) const {
  if (!hasMaxTrustedScoringSignalsURLLength()) {
  return fallback_value;
}
return member_max_trusted_scoring_signals_url_length_;
}
void setMaxTrustedScoringSignalsURLLength(int32_t value) {
  member_max_trusted_scoring_signals_url_length_ = value;
has_max_trusted_scoring_signals_url_length_ = true;
}

bool hasPerBuyerCumulativeTimeouts() const {
  return !member_per_buyer_cumulative_timeouts_.IsEmpty();
}
const MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUnsignedLongLong>>>& perBuyerCumulativeTimeouts() const {
  DCHECK(hasPerBuyerCumulativeTimeouts());
return member_per_buyer_cumulative_timeouts_;
}
ScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUnsignedLongLong>>> getPerBuyerCumulativeTimeoutsOr(const MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUnsignedLongLong>>>& fallback_value) const {
  if (!hasPerBuyerCumulativeTimeouts()) {
  return fallback_value;
}
return member_per_buyer_cumulative_timeouts_;
}
void setPerBuyerCumulativeTimeouts(const MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUnsignedLongLong>>>& value) {
  member_per_buyer_cumulative_timeouts_ = value;
}

bool hasPerBuyerCurrencies() const {
  return !member_per_buyer_currencies_.IsEmpty();
}
const MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUSVString>>>& perBuyerCurrencies() const {
  DCHECK(hasPerBuyerCurrencies());
return member_per_buyer_currencies_;
}
ScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUSVString>>> getPerBuyerCurrenciesOr(const MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUSVString>>>& fallback_value) const {
  if (!hasPerBuyerCurrencies()) {
  return fallback_value;
}
return member_per_buyer_currencies_;
}
void setPerBuyerCurrencies(const MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUSVString>>>& value) {
  member_per_buyer_currencies_ = value;
}

bool hasPerBuyerExperimentGroupIds() const {
  return has_per_buyer_experiment_group_ids_;
}
const Vector<std::pair<String, uint16_t>>& perBuyerExperimentGroupIds() const {
  DCHECK(hasPerBuyerExperimentGroupIds());
return member_per_buyer_experiment_group_ids_;
}
Vector<std::pair<String, uint16_t>> getPerBuyerExperimentGroupIdsOr(const Vector<std::pair<String, uint16_t>>& fallback_value) const;
Vector<std::pair<String, uint16_t>> getPerBuyerExperimentGroupIdsOr(Vector<std::pair<String, uint16_t>>&& fallback_value) const;
void setPerBuyerExperimentGroupIds(const Vector<std::pair<String, uint16_t>>& value);
void setPerBuyerExperimentGroupIds(Vector<std::pair<String, uint16_t>>&& value);

bool hasPerBuyerGroupLimits() const {
  return has_per_buyer_group_limits_;
}
const Vector<std::pair<String, uint16_t>>& perBuyerGroupLimits() const {
  DCHECK(hasPerBuyerGroupLimits());
return member_per_buyer_group_limits_;
}
Vector<std::pair<String, uint16_t>> getPerBuyerGroupLimitsOr(const Vector<std::pair<String, uint16_t>>& fallback_value) const;
Vector<std::pair<String, uint16_t>> getPerBuyerGroupLimitsOr(Vector<std::pair<String, uint16_t>>&& fallback_value) const;
void setPerBuyerGroupLimits(const Vector<std::pair<String, uint16_t>>& value);
void setPerBuyerGroupLimits(Vector<std::pair<String, uint16_t>>&& value);

bool hasPerBuyerMultiBidLimits() const {
  return has_per_buyer_multi_bid_limits_;
}
const Vector<std::pair<String, uint16_t>>& perBuyerMultiBidLimits() const {
  DCHECK(hasPerBuyerMultiBidLimits());
return member_per_buyer_multi_bid_limits_;
}
Vector<std::pair<String, uint16_t>> getPerBuyerMultiBidLimitsOr(const Vector<std::pair<String, uint16_t>>& fallback_value) const;
Vector<std::pair<String, uint16_t>> getPerBuyerMultiBidLimitsOr(Vector<std::pair<String, uint16_t>>&& fallback_value) const;
void setPerBuyerMultiBidLimits(const Vector<std::pair<String, uint16_t>>& value);
void setPerBuyerMultiBidLimits(Vector<std::pair<String, uint16_t>>&& value);

bool hasPerBuyerPrioritySignals() const {
  return has_per_buyer_priority_signals_;
}
const Vector<std::pair<String, Vector<std::pair<String, double>>>>& perBuyerPrioritySignals() const {
  DCHECK(hasPerBuyerPrioritySignals());
return member_per_buyer_priority_signals_;
}
Vector<std::pair<String, Vector<std::pair<String, double>>>> getPerBuyerPrioritySignalsOr(const Vector<std::pair<String, Vector<std::pair<String, double>>>>& fallback_value) const;
Vector<std::pair<String, Vector<std::pair<String, double>>>> getPerBuyerPrioritySignalsOr(Vector<std::pair<String, Vector<std::pair<String, double>>>>&& fallback_value) const;
void setPerBuyerPrioritySignals(const Vector<std::pair<String, Vector<std::pair<String, double>>>>& value);
void setPerBuyerPrioritySignals(Vector<std::pair<String, Vector<std::pair<String, double>>>>&& value);

bool hasPerBuyerRealTimeReportingConfig() const {
  return has_per_buyer_real_time_reporting_config_;
}
const HeapVector<std::pair<String, Member<AuctionRealTimeReportingConfig>>>& perBuyerRealTimeReportingConfig() const {
  DCHECK(hasPerBuyerRealTimeReportingConfig());
return member_per_buyer_real_time_reporting_config_;
}
HeapVector<std::pair<String, Member<AuctionRealTimeReportingConfig>>> getPerBuyerRealTimeReportingConfigOr(const HeapVector<std::pair<String, Member<AuctionRealTimeReportingConfig>>>& fallback_value) const;
HeapVector<std::pair<String, Member<AuctionRealTimeReportingConfig>>> getPerBuyerRealTimeReportingConfigOr(HeapVector<std::pair<String, Member<AuctionRealTimeReportingConfig>>>&& fallback_value) const;
void setPerBuyerRealTimeReportingConfig(const HeapVector<std::pair<String, Member<AuctionRealTimeReportingConfig>>>& value);
void setPerBuyerRealTimeReportingConfig(HeapVector<std::pair<String, Member<AuctionRealTimeReportingConfig>>>&& value);

bool hasPerBuyerSignals() const {
  return !member_per_buyer_signals_.IsEmpty();
}
const MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLAny>>>& perBuyerSignals() const {
  DCHECK(hasPerBuyerSignals());
return member_per_buyer_signals_;
}
ScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLAny>>> getPerBuyerSignalsOr(const MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLAny>>>& fallback_value) const {
  if (!hasPerBuyerSignals()) {
  return fallback_value;
}
return member_per_buyer_signals_;
}
void setPerBuyerSignals(const MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLAny>>>& value) {
  member_per_buyer_signals_ = value;
}

bool hasPerBuyerTKVSignals() const {
  return has_per_buyer_tkv_signals_;
}
const HeapVector<std::pair<String, MemberScriptPromise<IDLAny>>>& perBuyerTKVSignals() const {
  DCHECK(hasPerBuyerTKVSignals());
return member_per_buyer_tkv_signals_;
}
HeapVector<std::pair<String, MemberScriptPromise<IDLAny>>> getPerBuyerTKVSignalsOr(const HeapVector<std::pair<String, MemberScriptPromise<IDLAny>>>& fallback_value) const;
HeapVector<std::pair<String, MemberScriptPromise<IDLAny>>> getPerBuyerTKVSignalsOr(HeapVector<std::pair<String, MemberScriptPromise<IDLAny>>>&& fallback_value) const;
void setPerBuyerTKVSignals(const HeapVector<std::pair<String, MemberScriptPromise<IDLAny>>>& value);
void setPerBuyerTKVSignals(HeapVector<std::pair<String, MemberScriptPromise<IDLAny>>>&& value);

bool hasPerBuyerTimeouts() const {
  return !member_per_buyer_timeouts_.IsEmpty();
}
const MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUnsignedLongLong>>>& perBuyerTimeouts() const {
  DCHECK(hasPerBuyerTimeouts());
return member_per_buyer_timeouts_;
}
ScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUnsignedLongLong>>> getPerBuyerTimeoutsOr(const MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUnsignedLongLong>>>& fallback_value) const {
  if (!hasPerBuyerTimeouts()) {
  return fallback_value;
}
return member_per_buyer_timeouts_;
}
void setPerBuyerTimeouts(const MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUnsignedLongLong>>>& value) {
  member_per_buyer_timeouts_ = value;
}

bool hasPrivateAggregationConfig() const {
  return has_private_aggregation_config_;
}
ProtectedAudiencePrivateAggregationConfig* privateAggregationConfig() const {
  DCHECK(hasPrivateAggregationConfig());
return member_private_aggregation_config_.Get();
}
ProtectedAudiencePrivateAggregationConfig* getPrivateAggregationConfigOr(ProtectedAudiencePrivateAggregationConfig* fallback_value) const {
  if (!hasPrivateAggregationConfig()) {
  return fallback_value;
}
return member_private_aggregation_config_.Get();
}
void setPrivateAggregationConfig(ProtectedAudiencePrivateAggregationConfig* value) {
  member_private_aggregation_config_ = value;
has_private_aggregation_config_ = true;
DCHECK(member_private_aggregation_config_);
}

bool hasReportingTimeout() const {
  return has_reporting_timeout_;
}
uint64_t reportingTimeout() const {
  DCHECK(hasReportingTimeout());
return member_reporting_timeout_;
}
uint64_t getReportingTimeoutOr(uint64_t fallback_value) const {
  if (!hasReportingTimeout()) {
  return fallback_value;
}
return member_reporting_timeout_;
}
void setReportingTimeout(uint64_t value) {
  member_reporting_timeout_ = value;
has_reporting_timeout_ = true;
}

bool hasRequestId() const {
  return has_request_id_;
}
const String& requestId() const {
  DCHECK(hasRequestId());
return member_request_id_;
}
String getRequestIdOr(const String& fallback_value) const;
String getRequestIdOr(String&& fallback_value) const;
void setRequestId(const String& value);
void setRequestId(String&& value);

bool hasRequestedSize() const {
  return has_requested_size_;
}
AuctionAdInterestGroupSize* requestedSize() const {
  DCHECK(hasRequestedSize());
return member_requested_size_.Get();
}
AuctionAdInterestGroupSize* getRequestedSizeOr(AuctionAdInterestGroupSize* fallback_value) const {
  if (!hasRequestedSize()) {
  return fallback_value;
}
return member_requested_size_.Get();
}
void setRequestedSize(AuctionAdInterestGroupSize* value) {
  member_requested_size_ = value;
has_requested_size_ = true;
DCHECK(member_requested_size_);
}

bool hasRequiredSellerCapabilities() const {
  return has_required_seller_capabilities_;
}
const Vector<String>& requiredSellerCapabilities() const {
  DCHECK(hasRequiredSellerCapabilities());
return member_required_seller_capabilities_;
}
Vector<String> getRequiredSellerCapabilitiesOr(const Vector<String>& fallback_value) const;
Vector<String> getRequiredSellerCapabilitiesOr(Vector<String>&& fallback_value) const;
void setRequiredSellerCapabilities(const Vector<String>& value);
void setRequiredSellerCapabilities(Vector<String>&& value);

bool hasResolveToConfig() const {
  return !member_resolve_to_config_.IsEmpty();
}
const MemberScriptPromise<IDLBoolean>& resolveToConfig() const {
  DCHECK(hasResolveToConfig());
return member_resolve_to_config_;
}
ScriptPromise<IDLBoolean> getResolveToConfigOr(const MemberScriptPromise<IDLBoolean>& fallback_value) const {
  if (!hasResolveToConfig()) {
  return fallback_value;
}
return member_resolve_to_config_;
}
void setResolveToConfig(const MemberScriptPromise<IDLBoolean>& value) {
  member_resolve_to_config_ = value;
}

bool hasSeller() const {
  return true;
}
const String& seller() const {
  return member_seller_;
}
void setSeller(const String& value);
void setSeller(String&& value);

bool hasSellerCurrency() const {
  return has_seller_currency_;
}
const String& sellerCurrency() const {
  DCHECK(hasSellerCurrency());
return member_seller_currency_;
}
String getSellerCurrencyOr(const String& fallback_value) const;
String getSellerCurrencyOr(String&& fallback_value) const;
void setSellerCurrency(const String& value);
void setSellerCurrency(String&& value);

bool hasSellerExperimentGroupId() const {
  return has_seller_experiment_group_id_;
}
uint16_t sellerExperimentGroupId() const {
  DCHECK(hasSellerExperimentGroupId());
return member_seller_experiment_group_id_;
}
uint16_t getSellerExperimentGroupIdOr(uint16_t fallback_value) const {
  if (!hasSellerExperimentGroupId()) {
  return fallback_value;
}
return member_seller_experiment_group_id_;
}
void setSellerExperimentGroupId(uint16_t value) {
  member_seller_experiment_group_id_ = value;
has_seller_experiment_group_id_ = true;
}

bool hasSellerRealTimeReportingConfig() const {
  return has_seller_real_time_reporting_config_;
}
AuctionRealTimeReportingConfig* sellerRealTimeReportingConfig() const {
  DCHECK(hasSellerRealTimeReportingConfig());
return member_seller_real_time_reporting_config_.Get();
}
AuctionRealTimeReportingConfig* getSellerRealTimeReportingConfigOr(AuctionRealTimeReportingConfig* fallback_value) const {
  if (!hasSellerRealTimeReportingConfig()) {
  return fallback_value;
}
return member_seller_real_time_reporting_config_.Get();
}
void setSellerRealTimeReportingConfig(AuctionRealTimeReportingConfig* value) {
  member_seller_real_time_reporting_config_ = value;
has_seller_real_time_reporting_config_ = true;
DCHECK(member_seller_real_time_reporting_config_);
}

bool hasSellerSignals() const {
  return !member_seller_signals_.IsEmpty();
}
const MemberScriptPromise<IDLAny>& sellerSignals() const {
  DCHECK(hasSellerSignals());
return member_seller_signals_;
}
ScriptPromise<IDLAny> getSellerSignalsOr(const MemberScriptPromise<IDLAny>& fallback_value) const {
  if (!hasSellerSignals()) {
  return fallback_value;
}
return member_seller_signals_;
}
void setSellerSignals(const MemberScriptPromise<IDLAny>& value) {
  member_seller_signals_ = value;
}

bool hasSellerTKVSignals() const {
  return !member_seller_tkv_signals_.IsEmpty();
}
const MemberScriptPromise<IDLAny>& sellerTKVSignals() const {
  DCHECK(hasSellerTKVSignals());
return member_seller_tkv_signals_;
}
ScriptPromise<IDLAny> getSellerTKVSignalsOr(const MemberScriptPromise<IDLAny>& fallback_value) const {
  if (!hasSellerTKVSignals()) {
  return fallback_value;
}
return member_seller_tkv_signals_;
}
void setSellerTKVSignals(const MemberScriptPromise<IDLAny>& value) {
  member_seller_tkv_signals_ = value;
}

bool hasSellerTimeout() const {
  return has_seller_timeout_;
}
uint64_t sellerTimeout() const {
  DCHECK(hasSellerTimeout());
return member_seller_timeout_;
}
uint64_t getSellerTimeoutOr(uint64_t fallback_value) const {
  if (!hasSellerTimeout()) {
  return fallback_value;
}
return member_seller_timeout_;
}
void setSellerTimeout(uint64_t value) {
  member_seller_timeout_ = value;
has_seller_timeout_ = true;
}

bool hasSendCreativeScanningMetadata() const {
  return has_send_creative_scanning_metadata_;
}
bool sendCreativeScanningMetadata() const {
  DCHECK(hasSendCreativeScanningMetadata());
return member_send_creative_scanning_metadata_;
}
bool getSendCreativeScanningMetadataOr(bool fallback_value) const {
  if (!hasSendCreativeScanningMetadata()) {
  return fallback_value;
}
return member_send_creative_scanning_metadata_;
}
void setSendCreativeScanningMetadata(bool value) {
  member_send_creative_scanning_metadata_ = value;
has_send_creative_scanning_metadata_ = true;
}

bool hasServerResponse() const {
  return !member_server_response_.IsEmpty();
}
const MemberScriptPromise<NotShared<DOMUint8Array>>& serverResponse() const {
  DCHECK(hasServerResponse());
return member_server_response_;
}
ScriptPromise<NotShared<DOMUint8Array>> getServerResponseOr(const MemberScriptPromise<NotShared<DOMUint8Array>>& fallback_value) const {
  if (!hasServerResponse()) {
  return fallback_value;
}
return member_server_response_;
}
void setServerResponse(const MemberScriptPromise<NotShared<DOMUint8Array>>& value) {
  member_server_response_ = value;
}

bool hasSignal() const {
  return has_signal_;
}
AbortSignal* signal() const {
  DCHECK(hasSignal());
return member_signal_.Get();
}
AbortSignal* getSignalOr(AbortSignal* fallback_value) const {
  if (!hasSignal()) {
  return fallback_value;
}
return member_signal_.Get();
}
void setSignal(AbortSignal* value) {
  member_signal_ = value;
has_signal_ = true;
}

bool hasTrustedScoringSignalsCoordinator() const {
  return has_trusted_scoring_signals_coordinator_;
}
const String& trustedScoringSignalsCoordinator() const {
  DCHECK(hasTrustedScoringSignalsCoordinator());
return member_trusted_scoring_signals_coordinator_;
}
String getTrustedScoringSignalsCoordinatorOr(const String& fallback_value) const;
String getTrustedScoringSignalsCoordinatorOr(String&& fallback_value) const;
void setTrustedScoringSignalsCoordinator(const String& value);
void setTrustedScoringSignalsCoordinator(String&& value);

bool hasTrustedScoringSignalsURL() const {
  return has_trusted_scoring_signals_url_;
}
const String& trustedScoringSignalsURL() const {
  DCHECK(hasTrustedScoringSignalsURL());
return member_trusted_scoring_signals_url_;
}
String getTrustedScoringSignalsURLOr(const String& fallback_value) const;
String getTrustedScoringSignalsURLOr(String&& fallback_value) const;
void setTrustedScoringSignalsURL(const String& value);
void setTrustedScoringSignalsURL(String&& value);

bool hasTrustedScoringSignalsUrlDeprecated() const {
  return has_trusted_scoring_signals_url_deprecated_;
}
const String& trustedScoringSignalsUrlDeprecated() const {
  DCHECK(hasTrustedScoringSignalsUrlDeprecated());
return member_trusted_scoring_signals_url_deprecated_;
}
String getTrustedScoringSignalsUrlDeprecatedOr(const String& fallback_value) const;
String getTrustedScoringSignalsUrlDeprecatedOr(String&& fallback_value) const;
void setTrustedScoringSignalsUrlDeprecated(const String& value);
void setTrustedScoringSignalsUrlDeprecated(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 45;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_all_slots_requested_sizes_ = false;
bool has_auction_nonce_ = false;
bool has_auction_report_buyer_debug_mode_config_ = false;
bool has_auction_report_buyer_keys_ = false;
bool has_auction_report_buyers_ = false;
bool has_component_auctions_ = false;
bool has_decision_logic_url_ = false;
bool has_decision_logic_url_deprecated_ = false;
bool has_execution_mode_ = false;
bool has_interest_group_buyers_ = false;
bool has_max_trusted_scoring_signals_url_length_ = false;
bool has_per_buyer_experiment_group_ids_ = false;
bool has_per_buyer_group_limits_ = false;
bool has_per_buyer_multi_bid_limits_ = false;
bool has_per_buyer_priority_signals_ = false;
bool has_per_buyer_real_time_reporting_config_ = false;
bool has_per_buyer_tkv_signals_ = false;
bool has_private_aggregation_config_ = false;
bool has_reporting_timeout_ = false;
bool has_request_id_ = false;
bool has_requested_size_ = false;
bool has_required_seller_capabilities_ = false;
bool has_seller_currency_ = false;
bool has_seller_experiment_group_id_ = false;
bool has_seller_real_time_reporting_config_ = false;
bool has_seller_timeout_ = false;
bool has_send_creative_scanning_metadata_ = false;
bool has_signal_ = false;
bool has_trusted_scoring_signals_coordinator_ = false;
bool has_trusted_scoring_signals_url_ = false;
bool has_trusted_scoring_signals_url_deprecated_ = false;

MemberScriptPromise<IDLUndefined> member_additional_bids_;
HeapVector<Member<AuctionAdInterestGroupSize>> member_all_slots_requested_sizes_;
String member_auction_nonce_;
Member<AuctionReportBuyerDebugModeConfig> member_auction_report_buyer_debug_mode_config_;
Vector<BigInt> member_auction_report_buyer_keys_;
HeapVector<std::pair<String, Member<AuctionReportBuyersConfig>>> member_auction_report_buyers_;
MemberScriptPromise<IDLAny> member_auction_signals_;
HeapVector<Member<AuctionAdConfig>> member_component_auctions_;
String member_decision_logic_url_;
String member_decision_logic_url_deprecated_;
MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUSVString>>> member_deprecated_render_url_replacements_;
MemberScriptPromise<IDLNullable<IDLUSVString>> member_direct_from_seller_signals_;
MemberScriptPromise<IDLNullable<IDLString>> member_direct_from_seller_signals_header_ad_slot_;
String member_execution_mode_;
Vector<String> member_interest_group_buyers_;
int32_t member_max_trusted_scoring_signals_url_length_;
MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUnsignedLongLong>>> member_per_buyer_cumulative_timeouts_;
MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUSVString>>> member_per_buyer_currencies_;
Vector<std::pair<String, uint16_t>> member_per_buyer_experiment_group_ids_;
Vector<std::pair<String, uint16_t>> member_per_buyer_group_limits_;
Vector<std::pair<String, uint16_t>> member_per_buyer_multi_bid_limits_;
Vector<std::pair<String, Vector<std::pair<String, double>>>> member_per_buyer_priority_signals_;
HeapVector<std::pair<String, Member<AuctionRealTimeReportingConfig>>> member_per_buyer_real_time_reporting_config_;
MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLAny>>> member_per_buyer_signals_;
HeapVector<std::pair<String, MemberScriptPromise<IDLAny>>> member_per_buyer_tkv_signals_;
MemberScriptPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUnsignedLongLong>>> member_per_buyer_timeouts_;
Member<ProtectedAudiencePrivateAggregationConfig> member_private_aggregation_config_;
uint64_t member_reporting_timeout_;
String member_request_id_;
Member<AuctionAdInterestGroupSize> member_requested_size_;
Vector<String> member_required_seller_capabilities_;
MemberScriptPromise<IDLBoolean> member_resolve_to_config_;
String member_seller_;
String member_seller_currency_;
uint16_t member_seller_experiment_group_id_;
Member<AuctionRealTimeReportingConfig> member_seller_real_time_reporting_config_;
MemberScriptPromise<IDLAny> member_seller_signals_;
MemberScriptPromise<IDLAny> member_seller_tkv_signals_;
uint64_t member_seller_timeout_;
bool member_send_creative_scanning_metadata_;
MemberScriptPromise<NotShared<DOMUint8Array>> member_server_response_;
Member<AbortSignal> member_signal_;
String member_trusted_scoring_signals_coordinator_;
String member_trusted_scoring_signals_url_;
String member_trusted_scoring_signals_url_deprecated_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUCTION_AD_CONFIG_H_
