// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_ad_config.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_ad_config.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_ad_interest_group_size.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_real_time_reporting_config.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_report_buyer_debug_mode_config.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_report_buyers_config.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_protected_audience_private_aggregation_config.h"
#include "third_party/blink/renderer/core/dom/abort_signal.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"additionalBids",
"allSlotsRequestedSizes",
"auctionNonce",
"auctionReportBuyerDebugModeConfig",
"auctionReportBuyerKeys",
"auctionReportBuyers",
"auctionSignals",
"componentAuctions",
"decisionLogicURL",
"decisionLogicUrl",
"deprecatedRenderURLReplacements",
"directFromSellerSignals",
"directFromSellerSignalsHeaderAdSlot",
"executionMode",
"interestGroupBuyers",
"maxTrustedScoringSignalsURLLength",
"perBuyerCumulativeTimeouts",
"perBuyerCurrencies",
"perBuyerExperimentGroupIds",
"perBuyerGroupLimits",
"perBuyerMultiBidLimits",
"perBuyerPrioritySignals",
"perBuyerRealTimeReportingConfig",
"perBuyerSignals",
"perBuyerTKVSignals",
"perBuyerTimeouts",
"privateAggregationConfig",
"reportingTimeout",
"requestId",
"requestedSize",
"requiredSellerCapabilities",
"resolveToConfig",
"seller",
"sellerCurrency",
"sellerExperimentGroupId",
"sellerRealTimeReportingConfig",
"sellerSignals",
"sellerTKVSignals",
"sellerTimeout",
"sendCreativeScanningMetadata",
"serverResponse",
"signal",
"trustedScoringSignalsCoordinator",
"trustedScoringSignalsURL",
"trustedScoringSignalsUrl",
};


}  // namespace 

AuctionAdConfig* AuctionAdConfig::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AuctionAdConfig* dictionary = MakeGarbageCollected<AuctionAdConfig>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AuctionAdConfig";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AuctionAdConfig::AuctionAdConfig() {
  
}

 AuctionAdConfig::AuctionAdConfig(v8::Isolate* isolate) {
  
}










HeapVector<Member<AuctionAdInterestGroupSize>> AuctionAdConfig::getAllSlotsRequestedSizesOr(const HeapVector<Member<AuctionAdInterestGroupSize>>& fallback_value) const {
  if (!hasAllSlotsRequestedSizes()) {
  return fallback_value;
}
return member_all_slots_requested_sizes_;
}

HeapVector<Member<AuctionAdInterestGroupSize>> AuctionAdConfig::getAllSlotsRequestedSizesOr(HeapVector<Member<AuctionAdInterestGroupSize>>&& fallback_value) const {
  if (!hasAllSlotsRequestedSizes()) {
  return std::move(fallback_value);
}
return member_all_slots_requested_sizes_;
}

void AuctionAdConfig::setAllSlotsRequestedSizes(const HeapVector<Member<AuctionAdInterestGroupSize>>& value) {
  member_all_slots_requested_sizes_ = value;
has_all_slots_requested_sizes_ = true;
}

void AuctionAdConfig::setAllSlotsRequestedSizes(HeapVector<Member<AuctionAdInterestGroupSize>>&& value) {
  member_all_slots_requested_sizes_ = std::move(value);
has_all_slots_requested_sizes_ = true;
}




String AuctionAdConfig::getAuctionNonceOr(const String& fallback_value) const {
  if (!hasAuctionNonce()) {
  return fallback_value;
}
return member_auction_nonce_;
}

String AuctionAdConfig::getAuctionNonceOr(String&& fallback_value) const {
  if (!hasAuctionNonce()) {
  return std::move(fallback_value);
}
return member_auction_nonce_;
}

void AuctionAdConfig::setAuctionNonce(const String& value) {
  member_auction_nonce_ = value;
has_auction_nonce_ = true;
}

void AuctionAdConfig::setAuctionNonce(String&& value) {
  member_auction_nonce_ = std::move(value);
has_auction_nonce_ = true;
}











Vector<BigInt> AuctionAdConfig::getAuctionReportBuyerKeysOr(const Vector<BigInt>& fallback_value) const {
  if (!hasAuctionReportBuyerKeys()) {
  return fallback_value;
}
return member_auction_report_buyer_keys_;
}

Vector<BigInt> AuctionAdConfig::getAuctionReportBuyerKeysOr(Vector<BigInt>&& fallback_value) const {
  if (!hasAuctionReportBuyerKeys()) {
  return std::move(fallback_value);
}
return member_auction_report_buyer_keys_;
}

void AuctionAdConfig::setAuctionReportBuyerKeys(const Vector<BigInt>& value) {
  member_auction_report_buyer_keys_ = value;
has_auction_report_buyer_keys_ = true;
}

void AuctionAdConfig::setAuctionReportBuyerKeys(Vector<BigInt>&& value) {
  member_auction_report_buyer_keys_ = std::move(value);
has_auction_report_buyer_keys_ = true;
}




HeapVector<std::pair<String, Member<AuctionReportBuyersConfig>>> AuctionAdConfig::getAuctionReportBuyersOr(const HeapVector<std::pair<String, Member<AuctionReportBuyersConfig>>>& fallback_value) const {
  if (!hasAuctionReportBuyers()) {
  return fallback_value;
}
return member_auction_report_buyers_;
}

HeapVector<std::pair<String, Member<AuctionReportBuyersConfig>>> AuctionAdConfig::getAuctionReportBuyersOr(HeapVector<std::pair<String, Member<AuctionReportBuyersConfig>>>&& fallback_value) const {
  if (!hasAuctionReportBuyers()) {
  return std::move(fallback_value);
}
return member_auction_report_buyers_;
}

void AuctionAdConfig::setAuctionReportBuyers(const HeapVector<std::pair<String, Member<AuctionReportBuyersConfig>>>& value) {
  member_auction_report_buyers_ = value;
has_auction_report_buyers_ = true;
}

void AuctionAdConfig::setAuctionReportBuyers(HeapVector<std::pair<String, Member<AuctionReportBuyersConfig>>>&& value) {
  member_auction_report_buyers_ = std::move(value);
has_auction_report_buyers_ = true;
}











HeapVector<Member<AuctionAdConfig>> AuctionAdConfig::getComponentAuctionsOr(const HeapVector<Member<AuctionAdConfig>>& fallback_value) const {
  if (!hasComponentAuctions()) {
  return fallback_value;
}
return member_component_auctions_;
}

HeapVector<Member<AuctionAdConfig>> AuctionAdConfig::getComponentAuctionsOr(HeapVector<Member<AuctionAdConfig>>&& fallback_value) const {
  if (!hasComponentAuctions()) {
  return std::move(fallback_value);
}
return member_component_auctions_;
}

void AuctionAdConfig::setComponentAuctions(const HeapVector<Member<AuctionAdConfig>>& value) {
  member_component_auctions_ = value;
has_component_auctions_ = true;
}

void AuctionAdConfig::setComponentAuctions(HeapVector<Member<AuctionAdConfig>>&& value) {
  member_component_auctions_ = std::move(value);
has_component_auctions_ = true;
}




String AuctionAdConfig::getDecisionLogicURLOr(const String& fallback_value) const {
  if (!hasDecisionLogicURL()) {
  return fallback_value;
}
return member_decision_logic_url_;
}

String AuctionAdConfig::getDecisionLogicURLOr(String&& fallback_value) const {
  if (!hasDecisionLogicURL()) {
  return std::move(fallback_value);
}
return member_decision_logic_url_;
}

void AuctionAdConfig::setDecisionLogicURL(const String& value) {
  member_decision_logic_url_ = value;
has_decision_logic_url_ = true;
}

void AuctionAdConfig::setDecisionLogicURL(String&& value) {
  member_decision_logic_url_ = std::move(value);
has_decision_logic_url_ = true;
}




String AuctionAdConfig::getDecisionLogicUrlDeprecatedOr(const String& fallback_value) const {
  if (!hasDecisionLogicUrlDeprecated()) {
  return fallback_value;
}
return member_decision_logic_url_deprecated_;
}

String AuctionAdConfig::getDecisionLogicUrlDeprecatedOr(String&& fallback_value) const {
  if (!hasDecisionLogicUrlDeprecated()) {
  return std::move(fallback_value);
}
return member_decision_logic_url_deprecated_;
}

void AuctionAdConfig::setDecisionLogicUrlDeprecated(const String& value) {
  member_decision_logic_url_deprecated_ = value;
has_decision_logic_url_deprecated_ = true;
}

void AuctionAdConfig::setDecisionLogicUrlDeprecated(String&& value) {
  member_decision_logic_url_deprecated_ = std::move(value);
has_decision_logic_url_deprecated_ = true;
}

























String AuctionAdConfig::getExecutionModeOr(const String& fallback_value) const {
  if (!hasExecutionMode()) {
  return fallback_value;
}
return member_execution_mode_;
}

String AuctionAdConfig::getExecutionModeOr(String&& fallback_value) const {
  if (!hasExecutionMode()) {
  return std::move(fallback_value);
}
return member_execution_mode_;
}

void AuctionAdConfig::setExecutionMode(const String& value) {
  member_execution_mode_ = value;
has_execution_mode_ = true;
}

void AuctionAdConfig::setExecutionMode(String&& value) {
  member_execution_mode_ = std::move(value);
has_execution_mode_ = true;
}




Vector<String> AuctionAdConfig::getInterestGroupBuyersOr(const Vector<String>& fallback_value) const {
  if (!hasInterestGroupBuyers()) {
  return fallback_value;
}
return member_interest_group_buyers_;
}

Vector<String> AuctionAdConfig::getInterestGroupBuyersOr(Vector<String>&& fallback_value) const {
  if (!hasInterestGroupBuyers()) {
  return std::move(fallback_value);
}
return member_interest_group_buyers_;
}

void AuctionAdConfig::setInterestGroupBuyers(const Vector<String>& value) {
  member_interest_group_buyers_ = value;
has_interest_group_buyers_ = true;
}

void AuctionAdConfig::setInterestGroupBuyers(Vector<String>&& value) {
  member_interest_group_buyers_ = std::move(value);
has_interest_group_buyers_ = true;
}

























Vector<std::pair<String, uint16_t>> AuctionAdConfig::getPerBuyerExperimentGroupIdsOr(const Vector<std::pair<String, uint16_t>>& fallback_value) const {
  if (!hasPerBuyerExperimentGroupIds()) {
  return fallback_value;
}
return member_per_buyer_experiment_group_ids_;
}

Vector<std::pair<String, uint16_t>> AuctionAdConfig::getPerBuyerExperimentGroupIdsOr(Vector<std::pair<String, uint16_t>>&& fallback_value) const {
  if (!hasPerBuyerExperimentGroupIds()) {
  return std::move(fallback_value);
}
return member_per_buyer_experiment_group_ids_;
}

void AuctionAdConfig::setPerBuyerExperimentGroupIds(const Vector<std::pair<String, uint16_t>>& value) {
  member_per_buyer_experiment_group_ids_ = value;
has_per_buyer_experiment_group_ids_ = true;
}

void AuctionAdConfig::setPerBuyerExperimentGroupIds(Vector<std::pair<String, uint16_t>>&& value) {
  member_per_buyer_experiment_group_ids_ = std::move(value);
has_per_buyer_experiment_group_ids_ = true;
}




Vector<std::pair<String, uint16_t>> AuctionAdConfig::getPerBuyerGroupLimitsOr(const Vector<std::pair<String, uint16_t>>& fallback_value) const {
  if (!hasPerBuyerGroupLimits()) {
  return fallback_value;
}
return member_per_buyer_group_limits_;
}

Vector<std::pair<String, uint16_t>> AuctionAdConfig::getPerBuyerGroupLimitsOr(Vector<std::pair<String, uint16_t>>&& fallback_value) const {
  if (!hasPerBuyerGroupLimits()) {
  return std::move(fallback_value);
}
return member_per_buyer_group_limits_;
}

void AuctionAdConfig::setPerBuyerGroupLimits(const Vector<std::pair<String, uint16_t>>& value) {
  member_per_buyer_group_limits_ = value;
has_per_buyer_group_limits_ = true;
}

void AuctionAdConfig::setPerBuyerGroupLimits(Vector<std::pair<String, uint16_t>>&& value) {
  member_per_buyer_group_limits_ = std::move(value);
has_per_buyer_group_limits_ = true;
}




Vector<std::pair<String, uint16_t>> AuctionAdConfig::getPerBuyerMultiBidLimitsOr(const Vector<std::pair<String, uint16_t>>& fallback_value) const {
  if (!hasPerBuyerMultiBidLimits()) {
  return fallback_value;
}
return member_per_buyer_multi_bid_limits_;
}

Vector<std::pair<String, uint16_t>> AuctionAdConfig::getPerBuyerMultiBidLimitsOr(Vector<std::pair<String, uint16_t>>&& fallback_value) const {
  if (!hasPerBuyerMultiBidLimits()) {
  return std::move(fallback_value);
}
return member_per_buyer_multi_bid_limits_;
}

void AuctionAdConfig::setPerBuyerMultiBidLimits(const Vector<std::pair<String, uint16_t>>& value) {
  member_per_buyer_multi_bid_limits_ = value;
has_per_buyer_multi_bid_limits_ = true;
}

void AuctionAdConfig::setPerBuyerMultiBidLimits(Vector<std::pair<String, uint16_t>>&& value) {
  member_per_buyer_multi_bid_limits_ = std::move(value);
has_per_buyer_multi_bid_limits_ = true;
}




Vector<std::pair<String, Vector<std::pair<String, double>>>> AuctionAdConfig::getPerBuyerPrioritySignalsOr(const Vector<std::pair<String, Vector<std::pair<String, double>>>>& fallback_value) const {
  if (!hasPerBuyerPrioritySignals()) {
  return fallback_value;
}
return member_per_buyer_priority_signals_;
}

Vector<std::pair<String, Vector<std::pair<String, double>>>> AuctionAdConfig::getPerBuyerPrioritySignalsOr(Vector<std::pair<String, Vector<std::pair<String, double>>>>&& fallback_value) const {
  if (!hasPerBuyerPrioritySignals()) {
  return std::move(fallback_value);
}
return member_per_buyer_priority_signals_;
}

void AuctionAdConfig::setPerBuyerPrioritySignals(const Vector<std::pair<String, Vector<std::pair<String, double>>>>& value) {
  member_per_buyer_priority_signals_ = value;
has_per_buyer_priority_signals_ = true;
}

void AuctionAdConfig::setPerBuyerPrioritySignals(Vector<std::pair<String, Vector<std::pair<String, double>>>>&& value) {
  member_per_buyer_priority_signals_ = std::move(value);
has_per_buyer_priority_signals_ = true;
}




HeapVector<std::pair<String, Member<AuctionRealTimeReportingConfig>>> AuctionAdConfig::getPerBuyerRealTimeReportingConfigOr(const HeapVector<std::pair<String, Member<AuctionRealTimeReportingConfig>>>& fallback_value) const {
  if (!hasPerBuyerRealTimeReportingConfig()) {
  return fallback_value;
}
return member_per_buyer_real_time_reporting_config_;
}

HeapVector<std::pair<String, Member<AuctionRealTimeReportingConfig>>> AuctionAdConfig::getPerBuyerRealTimeReportingConfigOr(HeapVector<std::pair<String, Member<AuctionRealTimeReportingConfig>>>&& fallback_value) const {
  if (!hasPerBuyerRealTimeReportingConfig()) {
  return std::move(fallback_value);
}
return member_per_buyer_real_time_reporting_config_;
}

void AuctionAdConfig::setPerBuyerRealTimeReportingConfig(const HeapVector<std::pair<String, Member<AuctionRealTimeReportingConfig>>>& value) {
  member_per_buyer_real_time_reporting_config_ = value;
has_per_buyer_real_time_reporting_config_ = true;
}

void AuctionAdConfig::setPerBuyerRealTimeReportingConfig(HeapVector<std::pair<String, Member<AuctionRealTimeReportingConfig>>>&& value) {
  member_per_buyer_real_time_reporting_config_ = std::move(value);
has_per_buyer_real_time_reporting_config_ = true;
}











HeapVector<std::pair<String, MemberScriptPromise<IDLAny>>> AuctionAdConfig::getPerBuyerTKVSignalsOr(const HeapVector<std::pair<String, MemberScriptPromise<IDLAny>>>& fallback_value) const {
  if (!hasPerBuyerTKVSignals()) {
  return fallback_value;
}
return member_per_buyer_tkv_signals_;
}

HeapVector<std::pair<String, MemberScriptPromise<IDLAny>>> AuctionAdConfig::getPerBuyerTKVSignalsOr(HeapVector<std::pair<String, MemberScriptPromise<IDLAny>>>&& fallback_value) const {
  if (!hasPerBuyerTKVSignals()) {
  return std::move(fallback_value);
}
return member_per_buyer_tkv_signals_;
}

void AuctionAdConfig::setPerBuyerTKVSignals(const HeapVector<std::pair<String, MemberScriptPromise<IDLAny>>>& value) {
  member_per_buyer_tkv_signals_ = value;
has_per_buyer_tkv_signals_ = true;
}

void AuctionAdConfig::setPerBuyerTKVSignals(HeapVector<std::pair<String, MemberScriptPromise<IDLAny>>>&& value) {
  member_per_buyer_tkv_signals_ = std::move(value);
has_per_buyer_tkv_signals_ = true;
}

























String AuctionAdConfig::getRequestIdOr(const String& fallback_value) const {
  if (!hasRequestId()) {
  return fallback_value;
}
return member_request_id_;
}

String AuctionAdConfig::getRequestIdOr(String&& fallback_value) const {
  if (!hasRequestId()) {
  return std::move(fallback_value);
}
return member_request_id_;
}

void AuctionAdConfig::setRequestId(const String& value) {
  member_request_id_ = value;
has_request_id_ = true;
}

void AuctionAdConfig::setRequestId(String&& value) {
  member_request_id_ = std::move(value);
has_request_id_ = true;
}











Vector<String> AuctionAdConfig::getRequiredSellerCapabilitiesOr(const Vector<String>& fallback_value) const {
  if (!hasRequiredSellerCapabilities()) {
  return fallback_value;
}
return member_required_seller_capabilities_;
}

Vector<String> AuctionAdConfig::getRequiredSellerCapabilitiesOr(Vector<String>&& fallback_value) const {
  if (!hasRequiredSellerCapabilities()) {
  return std::move(fallback_value);
}
return member_required_seller_capabilities_;
}

void AuctionAdConfig::setRequiredSellerCapabilities(const Vector<String>& value) {
  member_required_seller_capabilities_ = value;
has_required_seller_capabilities_ = true;
}

void AuctionAdConfig::setRequiredSellerCapabilities(Vector<String>&& value) {
  member_required_seller_capabilities_ = std::move(value);
has_required_seller_capabilities_ = true;
}











void AuctionAdConfig::setSeller(const String& value) {
  member_seller_ = value;
}

void AuctionAdConfig::setSeller(String&& value) {
  member_seller_ = std::move(value);
}




String AuctionAdConfig::getSellerCurrencyOr(const String& fallback_value) const {
  if (!hasSellerCurrency()) {
  return fallback_value;
}
return member_seller_currency_;
}

String AuctionAdConfig::getSellerCurrencyOr(String&& fallback_value) const {
  if (!hasSellerCurrency()) {
  return std::move(fallback_value);
}
return member_seller_currency_;
}

void AuctionAdConfig::setSellerCurrency(const String& value) {
  member_seller_currency_ = value;
has_seller_currency_ = true;
}

void AuctionAdConfig::setSellerCurrency(String&& value) {
  member_seller_currency_ = std::move(value);
has_seller_currency_ = true;
}




























































String AuctionAdConfig::getTrustedScoringSignalsCoordinatorOr(const String& fallback_value) const {
  if (!hasTrustedScoringSignalsCoordinator()) {
  return fallback_value;
}
return member_trusted_scoring_signals_coordinator_;
}

String AuctionAdConfig::getTrustedScoringSignalsCoordinatorOr(String&& fallback_value) const {
  if (!hasTrustedScoringSignalsCoordinator()) {
  return std::move(fallback_value);
}
return member_trusted_scoring_signals_coordinator_;
}

void AuctionAdConfig::setTrustedScoringSignalsCoordinator(const String& value) {
  member_trusted_scoring_signals_coordinator_ = value;
has_trusted_scoring_signals_coordinator_ = true;
}

void AuctionAdConfig::setTrustedScoringSignalsCoordinator(String&& value) {
  member_trusted_scoring_signals_coordinator_ = std::move(value);
has_trusted_scoring_signals_coordinator_ = true;
}




String AuctionAdConfig::getTrustedScoringSignalsURLOr(const String& fallback_value) const {
  if (!hasTrustedScoringSignalsURL()) {
  return fallback_value;
}
return member_trusted_scoring_signals_url_;
}

String AuctionAdConfig::getTrustedScoringSignalsURLOr(String&& fallback_value) const {
  if (!hasTrustedScoringSignalsURL()) {
  return std::move(fallback_value);
}
return member_trusted_scoring_signals_url_;
}

void AuctionAdConfig::setTrustedScoringSignalsURL(const String& value) {
  member_trusted_scoring_signals_url_ = value;
has_trusted_scoring_signals_url_ = true;
}

void AuctionAdConfig::setTrustedScoringSignalsURL(String&& value) {
  member_trusted_scoring_signals_url_ = std::move(value);
has_trusted_scoring_signals_url_ = true;
}




String AuctionAdConfig::getTrustedScoringSignalsUrlDeprecatedOr(const String& fallback_value) const {
  if (!hasTrustedScoringSignalsUrlDeprecated()) {
  return fallback_value;
}
return member_trusted_scoring_signals_url_deprecated_;
}

String AuctionAdConfig::getTrustedScoringSignalsUrlDeprecatedOr(String&& fallback_value) const {
  if (!hasTrustedScoringSignalsUrlDeprecated()) {
  return std::move(fallback_value);
}
return member_trusted_scoring_signals_url_deprecated_;
}

void AuctionAdConfig::setTrustedScoringSignalsUrlDeprecated(const String& value) {
  member_trusted_scoring_signals_url_deprecated_ = value;
has_trusted_scoring_signals_url_deprecated_ = true;
}

void AuctionAdConfig::setTrustedScoringSignalsUrlDeprecated(String&& value) {
  member_trusted_scoring_signals_url_deprecated_ = std::move(value);
has_trusted_scoring_signals_url_deprecated_ = true;
}




void AuctionAdConfig::Trace(Visitor* visitor) const {
  visitor->Trace(member_additional_bids_);
visitor->Trace(member_all_slots_requested_sizes_);
visitor->Trace(member_auction_report_buyer_debug_mode_config_);
visitor->Trace(member_auction_report_buyers_);
visitor->Trace(member_auction_signals_);
visitor->Trace(member_component_auctions_);
visitor->Trace(member_deprecated_render_url_replacements_);
visitor->Trace(member_direct_from_seller_signals_);
visitor->Trace(member_direct_from_seller_signals_header_ad_slot_);
visitor->Trace(member_per_buyer_cumulative_timeouts_);
visitor->Trace(member_per_buyer_currencies_);
visitor->Trace(member_per_buyer_real_time_reporting_config_);
visitor->Trace(member_per_buyer_signals_);
visitor->Trace(member_per_buyer_tkv_signals_);
visitor->Trace(member_per_buyer_timeouts_);
visitor->Trace(member_private_aggregation_config_);
visitor->Trace(member_requested_size_);
visitor->Trace(member_resolve_to_config_);
visitor->Trace(member_seller_real_time_reporting_config_);
visitor->Trace(member_seller_signals_);
visitor->Trace(member_seller_tkv_signals_);
visitor->Trace(member_server_response_);
visitor->Trace(member_signal_);
bindings::InputDictionaryBase::Trace(visitor);
}

void AuctionAdConfig::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AuctionAdConfig";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("additionalBids");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLPromise<IDLUndefined>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_additional_bids_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("allSlotsRequestedSizes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<AuctionAdInterestGroupSize>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_all_slots_requested_sizes_, member_all_slots_requested_sizes_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("auctionNonce");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_auction_nonce_, member_auction_nonce_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("auctionReportBuyerDebugModeConfig");
if (!bindings::GetDictionaryMemberFromV8Object<AuctionReportBuyerDebugModeConfig, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_auction_report_buyer_debug_mode_config_, member_auction_report_buyer_debug_mode_config_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("auctionReportBuyerKeys");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLBigint>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_auction_report_buyer_keys_, member_auction_report_buyer_keys_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("auctionReportBuyers");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLString, AuctionReportBuyersConfig>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_auction_report_buyers_, member_auction_report_buyers_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("auctionSignals");
if (!bindings::GetDictionaryMemberFromV8Object<IDLPromise<IDLAny>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_auction_signals_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("componentAuctions");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<AuctionAdConfig>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_component_auctions_, member_component_auctions_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("decisionLogicURL");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_decision_logic_url_, member_decision_logic_url_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("decisionLogicUrl");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_decision_logic_url_deprecated_, member_decision_logic_url_deprecated_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeDeprecatedRenderURLReplacementsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("deprecatedRenderURLReplacements");
if (!bindings::GetDictionaryMemberFromV8Object<IDLPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUSVString>>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), fallback_presence_var, member_deprecated_render_url_replacements_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::FledgeDirectFromSellerSignalsWebBundlesEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("directFromSellerSignals");
if (!bindings::GetDictionaryMemberFromV8Object<IDLPromise<IDLNullable<IDLUSVString>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), fallback_presence_var, member_direct_from_seller_signals_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::FledgeDirectFromSellerSignalsHeaderAdSlotEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("directFromSellerSignalsHeaderAdSlot");
if (!bindings::GetDictionaryMemberFromV8Object<IDLPromise<IDLNullable<IDLString>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), fallback_presence_var, member_direct_from_seller_signals_header_ad_slot_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::FledgeSellerScriptExecutionModeEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("executionMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_execution_mode_, member_execution_mode_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("interestGroupBuyers");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUSVString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_interest_group_buyers_, member_interest_group_buyers_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("maxTrustedScoringSignalsURLLength");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_max_trusted_scoring_signals_url_length_, member_max_trusted_scoring_signals_url_length_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("perBuyerCumulativeTimeouts");
if (!bindings::GetDictionaryMemberFromV8Object<IDLPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUnsignedLongLong>>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), fallback_presence_var, member_per_buyer_cumulative_timeouts_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("perBuyerCurrencies");
if (!bindings::GetDictionaryMemberFromV8Object<IDLPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUSVString>>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), fallback_presence_var, member_per_buyer_currencies_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("perBuyerExperimentGroupIds");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLUSVString, IDLUnsignedShort>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[18].Get(isolate), has_per_buyer_experiment_group_ids_, member_per_buyer_experiment_group_ids_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("perBuyerGroupLimits");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLUSVString, IDLUnsignedShort>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[19].Get(isolate), has_per_buyer_group_limits_, member_per_buyer_group_limits_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeMultiBidEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("perBuyerMultiBidLimits");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLUSVString, IDLUnsignedShort>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[20].Get(isolate), has_per_buyer_multi_bid_limits_, member_per_buyer_multi_bid_limits_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("perBuyerPrioritySignals");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLUSVString, IDLRecord<IDLUSVString, IDLDouble>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[21].Get(isolate), has_per_buyer_priority_signals_, member_per_buyer_priority_signals_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeRealTimeReportingEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("perBuyerRealTimeReportingConfig");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLUSVString, AuctionRealTimeReportingConfig>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[22].Get(isolate), has_per_buyer_real_time_reporting_config_, member_per_buyer_real_time_reporting_config_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("perBuyerSignals");
if (!bindings::GetDictionaryMemberFromV8Object<IDLPromise<IDLNullable<IDLRecord<IDLUSVString, IDLAny>>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[23].Get(isolate), fallback_presence_var, member_per_buyer_signals_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeTrustedSignalsKVv2ContextualDataEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("perBuyerTKVSignals");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLUSVString, IDLPromise<IDLAny>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[24].Get(isolate), has_per_buyer_tkv_signals_, member_per_buyer_tkv_signals_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("perBuyerTimeouts");
if (!bindings::GetDictionaryMemberFromV8Object<IDLPromise<IDLNullable<IDLRecord<IDLUSVString, IDLUnsignedLongLong>>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[25].Get(isolate), fallback_presence_var, member_per_buyer_timeouts_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("privateAggregationConfig");
if (!bindings::GetDictionaryMemberFromV8Object<ProtectedAudiencePrivateAggregationConfig, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[26].Get(isolate), has_private_aggregation_config_, member_private_aggregation_config_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reportingTimeout");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[27].Get(isolate), has_reporting_timeout_, member_reporting_timeout_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requestId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[28].Get(isolate), has_request_id_, member_request_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requestedSize");
if (!bindings::GetDictionaryMemberFromV8Object<AuctionAdInterestGroupSize, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[29].Get(isolate), has_requested_size_, member_requested_size_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requiredSellerCapabilities");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[30].Get(isolate), has_required_seller_capabilities_, member_required_seller_capabilities_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("resolveToConfig");
if (!bindings::GetDictionaryMemberFromV8Object<IDLPromise<IDLBoolean>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[31].Get(isolate), fallback_presence_var, member_resolve_to_config_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("seller");
constexpr bool is_required = true;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[32].Get(isolate), fallback_presence_var, member_seller_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sellerCurrency");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[33].Get(isolate), has_seller_currency_, member_seller_currency_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sellerExperimentGroupId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShort, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[34].Get(isolate), has_seller_experiment_group_id_, member_seller_experiment_group_id_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeRealTimeReportingEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("sellerRealTimeReportingConfig");
if (!bindings::GetDictionaryMemberFromV8Object<AuctionRealTimeReportingConfig, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[35].Get(isolate), has_seller_real_time_reporting_config_, member_seller_real_time_reporting_config_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("sellerSignals");
if (!bindings::GetDictionaryMemberFromV8Object<IDLPromise<IDLAny>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[36].Get(isolate), fallback_presence_var, member_seller_signals_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeTrustedSignalsKVv2ContextualDataEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("sellerTKVSignals");
if (!bindings::GetDictionaryMemberFromV8Object<IDLPromise<IDLAny>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[37].Get(isolate), fallback_presence_var, member_seller_tkv_signals_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("sellerTimeout");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[38].Get(isolate), has_seller_timeout_, member_seller_timeout_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeTrustedSignalsKVv1CreativeScanningEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("sendCreativeScanningMetadata");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[39].Get(isolate), has_send_creative_scanning_metadata_, member_send_creative_scanning_metadata_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("serverResponse");
if (!bindings::GetDictionaryMemberFromV8Object<IDLPromise<NotShared<DOMUint8Array>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[40].Get(isolate), fallback_presence_var, member_server_response_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("signal");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<AbortSignal>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[41].Get(isolate), has_signal_, member_signal_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeTrustedSignalsKVv2SupportEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("trustedScoringSignalsCoordinator");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[42].Get(isolate), has_trusted_scoring_signals_coordinator_, member_trusted_scoring_signals_coordinator_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("trustedScoringSignalsURL");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[43].Get(isolate), has_trusted_scoring_signals_url_, member_trusted_scoring_signals_url_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("trustedScoringSignalsUrl");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[44].Get(isolate), has_trusted_scoring_signals_url_deprecated_, member_trusted_scoring_signals_url_deprecated_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AuctionAdConfig::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
