// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_ad_request_config.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ad_properties.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ad_targeting.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_adproperties_adpropertiessequence.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"adProperties",
"adRequestUrl",
"anonymizedProxiedSignals",
"fallbackSource",
"publisherCode",
"targeting",
};


}  // namespace 

AdRequestConfig* AdRequestConfig::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AdRequestConfig* dictionary = MakeGarbageCollected<AdRequestConfig>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AdRequestConfig";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AdRequestConfig::AdRequestConfig() {
  
}

 AdRequestConfig::AdRequestConfig(v8::Isolate* isolate) {
  
}








void AdRequestConfig::setAdRequestUrl(const String& value) {
  member_ad_request_url_ = value;
}

void AdRequestConfig::setAdRequestUrl(String&& value) {
  member_ad_request_url_ = std::move(value);
}




Vector<V8AdSignals> AdRequestConfig::getAnonymizedProxiedSignalsOr(const Vector<V8AdSignals>& fallback_value) const {
  if (!hasAnonymizedProxiedSignals()) {
  return fallback_value;
}
return member_anonymized_proxied_signals_;
}

Vector<V8AdSignals> AdRequestConfig::getAnonymizedProxiedSignalsOr(Vector<V8AdSignals>&& fallback_value) const {
  if (!hasAnonymizedProxiedSignals()) {
  return std::move(fallback_value);
}
return member_anonymized_proxied_signals_;
}

void AdRequestConfig::setAnonymizedProxiedSignals(const Vector<V8AdSignals>& value) {
  member_anonymized_proxied_signals_ = value;
has_anonymized_proxied_signals_ = true;
}

void AdRequestConfig::setAnonymizedProxiedSignals(Vector<V8AdSignals>&& value) {
  member_anonymized_proxied_signals_ = std::move(value);
has_anonymized_proxied_signals_ = true;
}




String AdRequestConfig::getFallbackSourceOr(const String& fallback_value) const {
  if (!hasFallbackSource()) {
  return fallback_value;
}
return member_fallback_source_;
}

String AdRequestConfig::getFallbackSourceOr(String&& fallback_value) const {
  if (!hasFallbackSource()) {
  return std::move(fallback_value);
}
return member_fallback_source_;
}

void AdRequestConfig::setFallbackSource(const String& value) {
  member_fallback_source_ = value;
has_fallback_source_ = true;
}

void AdRequestConfig::setFallbackSource(String&& value) {
  member_fallback_source_ = std::move(value);
has_fallback_source_ = true;
}




String AdRequestConfig::getPublisherCodeOr(const String& fallback_value) const {
  if (!hasPublisherCode()) {
  return fallback_value;
}
return member_publisher_code_;
}

String AdRequestConfig::getPublisherCodeOr(String&& fallback_value) const {
  if (!hasPublisherCode()) {
  return std::move(fallback_value);
}
return member_publisher_code_;
}

void AdRequestConfig::setPublisherCode(const String& value) {
  member_publisher_code_ = value;
has_publisher_code_ = true;
}

void AdRequestConfig::setPublisherCode(String&& value) {
  member_publisher_code_ = std::move(value);
has_publisher_code_ = true;
}











void AdRequestConfig::Trace(Visitor* visitor) const {
  visitor->Trace(member_ad_properties_);
visitor->Trace(member_targeting_);
bindings::InputDictionaryBase::Trace(visitor);
}

void AdRequestConfig::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AdRequestConfig";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("adProperties");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionAdPropertiesOrAdPropertiesSequence, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_ad_properties_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("adRequestUrl");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_ad_request_url_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("anonymizedProxiedSignals");
constexpr bool is_optional = false;
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8AdSignals>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_anonymized_proxied_signals_, member_anonymized_proxied_signals_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("fallbackSource");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_fallback_source_, member_fallback_source_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("publisherCode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_publisher_code_, member_publisher_code_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("targeting");
if (!bindings::GetDictionaryMemberFromV8Object<AdTargeting, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_targeting_, member_targeting_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AdRequestConfig::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
