// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_ad_auction_data.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ad_auction_per_seller_data.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"request",
"requestId",
"requests",
};


}  // namespace 

AdAuctionData* AdAuctionData::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AdAuctionData* dictionary = MakeGarbageCollected<AdAuctionData>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AdAuctionData";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AdAuctionData::AdAuctionData() {
  
}

 AdAuctionData::AdAuctionData(v8::Isolate* isolate) {
  
}










void AdAuctionData::setRequestId(const String& value) {
  member_request_id_ = value;
}

void AdAuctionData::setRequestId(String&& value) {
  member_request_id_ = std::move(value);
}




HeapVector<Member<AdAuctionPerSellerData>> AdAuctionData::getRequestsOr(const HeapVector<Member<AdAuctionPerSellerData>>& fallback_value) const {
  if (!hasRequests()) {
  return fallback_value;
}
return member_requests_;
}

HeapVector<Member<AdAuctionPerSellerData>> AdAuctionData::getRequestsOr(HeapVector<Member<AdAuctionPerSellerData>>&& fallback_value) const {
  if (!hasRequests()) {
  return std::move(fallback_value);
}
return member_requests_;
}

void AdAuctionData::setRequests(const HeapVector<Member<AdAuctionPerSellerData>>& value) {
  member_requests_ = value;
has_requests_ = true;
}

void AdAuctionData::setRequests(HeapVector<Member<AdAuctionPerSellerData>>&& value) {
  member_requests_ = std::move(value);
has_requests_ = true;
}




void AdAuctionData::Trace(Visitor* visitor) const {
  visitor->Trace(member_request_);
visitor->Trace(member_requests_);
bindings::DictionaryBase::Trace(visitor);
}

void AdAuctionData::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void AdAuctionData::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasRequest()) {
  values[0] = ToV8Traits<NotShared<DOMUint8Array>>::ToV8(script_state, member_request_);
DCHECK(!values[0].IsEmpty());
}
if (hasRequestId()) {
  values[1] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_request_id_);
DCHECK(!values[1].IsEmpty());
}
if (RuntimeEnabledFeatures::FledgeBiddingAndAuctionServerAPIMultiSellerEnabled()) {
  if (hasRequests()) {
  values[2] = ToV8Traits<IDLSequence<AdAuctionPerSellerData>>::ToV8(script_state, member_requests_);
DCHECK(!values[2].IsEmpty());
}
}
}

const void* AdAuctionData::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> AdAuctionData::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void AdAuctionData::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AdAuctionData";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("request");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<NotShared<DOMUint8Array>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_request_, member_request_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requestId");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_request_id_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeBiddingAndAuctionServerAPIMultiSellerEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("requests");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<AdAuctionPerSellerData>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_requests_, member_requests_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> AdAuctionData::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
