// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/properties_per_feature_installer_for_testing.h"

#include "base/containers/span.h"
#include "base/notimplemented.h"
#include "base/notreached.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_origin_trials_test.h"
#include "third_party/blink/renderer/platform/bindings/script_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_context_data.h"

namespace blink {

namespace bindings {

namespace  {

void InstallPropertiesPerFeatureInternal(ScriptState* script_state, mojom::blink::OriginTrialFeature feature, base::span<const WrapperTypeInfo* const> wrapper_type_info_list) {
  V8PerContextData* per_context_data = script_state->PerContextData();
v8::Isolate* isolate = script_state->GetIsolate();
v8::Local<v8::Context> context = script_state->GetContext();
const DOMWrapperWorld& world = script_state->World();
V8InterfaceBridgeBase::FeatureSelector feature_selector(feature);

for (const auto* wrapper_type_info : wrapper_type_info_list) {
  v8::Local<v8::Object> instance_object;
  v8::Local<v8::Object> prototype_object;
  v8::Local<v8::Function> interface_object;
  v8::Local<v8::Template> interface_template =
      wrapper_type_info->GetV8ClassTemplate(isolate, world);

  switch (wrapper_type_info->idl_definition_kind) {
    case WrapperTypeInfo::kIdlInterface:
      if (!per_context_data->GetExistingConstructorAndPrototypeForType(
              wrapper_type_info, &prototype_object, &interface_object)) {
        continue;
      }
      break;
    case WrapperTypeInfo::kIdlNamespace:
      NOTIMPLEMENTED();
      break;
    default:
      NOTREACHED();
  }

  wrapper_type_info->install_context_dependent_props_func(
      context, world, instance_object, prototype_object,  interface_object,
      interface_template, feature_selector);
}
}

}  // namespace 

void InstallPropertiesPerFeatureForTesting(ScriptState* script_state, mojom::blink::OriginTrialFeature feature) {
  base::span<const WrapperTypeInfo* const> selected_wti_list;

switch (feature) {
  case mojom::blink::OriginTrialFeature::kOriginTrialsSampleAPI: {
    static const WrapperTypeInfo* const wti_list[] = {
V8OriginTrialsTest::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kOriginTrialsSampleAPIDeprecation: {
    static const WrapperTypeInfo* const wti_list[] = {
V8OriginTrialsTest::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kOriginTrialsSampleAPIImplied: {
    static const WrapperTypeInfo* const wti_list[] = {
V8OriginTrialsTest::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kOriginTrialsSampleAPIInvalidOS: {
    static const WrapperTypeInfo* const wti_list[] = {
V8OriginTrialsTest::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kOriginTrialsSampleAPINavigation: {
    static const WrapperTypeInfo* const wti_list[] = {
V8OriginTrialsTest::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kOriginTrialsSampleAPIThirdParty: {
    static const WrapperTypeInfo* const wti_list[] = {
V8OriginTrialsTest::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  default: {
    // Ignore unknown, deprecated, and unused features.
return;
  }
}

InstallPropertiesPerFeatureInternal(script_state, feature, selected_wti_list);
}

}  // namespace bindings

}  // namespace blink
