// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/properties_per_feature_installer.h"

#include "base/containers/span.h"
#include "base/notimplemented.h"
#include "base/notreached.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dedicated_worker_global_scope.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_document.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_anchor_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_iframe_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_mathml_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_navigator.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_entry.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_navigation_timing.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_request.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_security_policy_violation_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_shadow_root.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_shared_worker_global_scope.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_svg_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_window.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_rendering_context_2d.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_clipboard.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_supported_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_identity_credential.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_devices.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_stream_track.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_notification.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_offscreen_canvas_rendering_context_2d.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_paint_rendering_context_2d.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_paint_worklet_global_scope.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_encoded_audio_frame.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_encoded_video_frame.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_service_worker_global_scope.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_source_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_frame.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_session.h"
#include "third_party/blink/renderer/platform/bindings/script_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_context_data.h"

namespace blink {

namespace bindings {

namespace  {

void InstallPropertiesPerFeatureInternal(ScriptState* script_state, mojom::blink::OriginTrialFeature feature, base::span<const WrapperTypeInfo* const> wrapper_type_info_list) {
  V8PerContextData* per_context_data = script_state->PerContextData();
v8::Isolate* isolate = script_state->GetIsolate();
v8::Local<v8::Context> context = script_state->GetContext();
const DOMWrapperWorld& world = script_state->World();
V8InterfaceBridgeBase::FeatureSelector feature_selector(feature);

for (const auto* wrapper_type_info : wrapper_type_info_list) {
  v8::Local<v8::Object> instance_object;
  v8::Local<v8::Object> prototype_object;
  v8::Local<v8::Function> interface_object;
  v8::Local<v8::Template> interface_template =
      wrapper_type_info->GetV8ClassTemplate(isolate, world);

  switch (wrapper_type_info->idl_definition_kind) {
    case WrapperTypeInfo::kIdlInterface:
      if (!per_context_data->GetExistingConstructorAndPrototypeForType(
              wrapper_type_info, &prototype_object, &interface_object)) {
        continue;
      }
      break;
    case WrapperTypeInfo::kIdlNamespace:
      NOTIMPLEMENTED();
      break;
    default:
      NOTREACHED();
  }

  wrapper_type_info->install_context_dependent_props_func(
      context, world, instance_object, prototype_object,  interface_object,
      interface_template, feature_selector);
}
}

}  // namespace 

void InstallPropertiesPerFeature(ScriptState* script_state, mojom::blink::OriginTrialFeature feature) {
  base::span<const WrapperTypeInfo* const> selected_wti_list;

switch (feature) {
  case mojom::blink::OriginTrialFeature::kAIPromptAPI: {
    static const WrapperTypeInfo* const wti_list[] = {
V8DedicatedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8ServiceWorkerGlobalScope::GetWrapperTypeInfo(), 
V8SharedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kAIProofreadingAPI: {
    static const WrapperTypeInfo* const wti_list[] = {
V8DedicatedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8ServiceWorkerGlobalScope::GetWrapperTypeInfo(), 
V8SharedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kAIRewriterAPI: {
    static const WrapperTypeInfo* const wti_list[] = {
V8DedicatedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8ServiceWorkerGlobalScope::GetWrapperTypeInfo(), 
V8SharedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kAIWriterAPI: {
    static const WrapperTypeInfo* const wti_list[] = {
V8DedicatedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8ServiceWorkerGlobalScope::GetWrapperTypeInfo(), 
V8SharedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kAdInterestGroupAPI: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Navigator::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kAudioContextPlayoutStats: {
    static const WrapperTypeInfo* const wti_list[] = {
V8AudioContext::GetWrapperTypeInfo(), 
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kBackForwardCacheNotRestoredReasons: {
    static const WrapperTypeInfo* const wti_list[] = {
V8PerformanceNavigationTiming::GetWrapperTypeInfo(), 
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kBuiltInAIAPI: {
    static const WrapperTypeInfo* const wti_list[] = {
V8DedicatedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8ServiceWorkerGlobalScope::GetWrapperTypeInfo(), 
V8SharedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kCSPHashesV1: {
    static const WrapperTypeInfo* const wti_list[] = {
V8SecurityPolicyViolationEvent::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kCanvas2dMesh: {
    static const WrapperTypeInfo* const wti_list[] = {
V8CanvasRenderingContext2D::GetWrapperTypeInfo(), 
V8DedicatedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8OffscreenCanvasRenderingContext2D::GetWrapperTypeInfo(), 
V8PaintRenderingContext2D::GetWrapperTypeInfo(), 
V8PaintWorkletGlobalScope::GetWrapperTypeInfo(), 
V8ServiceWorkerGlobalScope::GetWrapperTypeInfo(), 
V8SharedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kClipboardChangeEvent: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Clipboard::GetWrapperTypeInfo(), 
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kCrashReportingStorageAPI: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kDigitalGoods: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kDocumentPolicyNegotiation: {
    static const WrapperTypeInfo* const wti_list[] = {
V8HTMLIFrameElement::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kFedCmMultipleIdentityProviders: {
    static const WrapperTypeInfo* const wti_list[] = {
V8IdentityCredential::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kFetchRetry: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Request::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kFledgeBiddingAndAuctionServerAPI: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Navigator::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kFocusgroup: {
    static const WrapperTypeInfo* const wti_list[] = {
V8HTMLElement::GetWrapperTypeInfo(), 
V8MathMLElement::GetWrapperTypeInfo(), 
V8SVGElement::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kHrefTranslate: {
    static const WrapperTypeInfo* const wti_list[] = {
V8HTMLAnchorElement::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kIncomingCallNotifications: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Notification::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kLanguageDetectionAPI: {
    static const WrapperTypeInfo* const wti_list[] = {
V8DedicatedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8ServiceWorkerGlobalScope::GetWrapperTypeInfo(), 
V8SharedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kMediaCaptureConfigurationChange: {
    static const WrapperTypeInfo* const wti_list[] = {
V8MediaStreamTrack::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kMediaSourceExtensionsForWebCodecs: {
    static const WrapperTypeInfo* const wti_list[] = {
V8SourceBuffer::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kNavigationId: {
    static const WrapperTypeInfo* const wti_list[] = {
V8PerformanceEntry::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kNotificationTriggers: {
    static const WrapperTypeInfo* const wti_list[] = {
V8DedicatedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8Notification::GetWrapperTypeInfo(), 
V8ServiceWorkerGlobalScope::GetWrapperTypeInfo(), 
V8SharedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kOriginTrialsSampleAPI: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kParakeet: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Navigator::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kPerformanceNavigationTimingConfidence: {
    static const WrapperTypeInfo* const wti_list[] = {
V8PerformanceNavigationTiming::GetWrapperTypeInfo(), 
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kPermissionElement: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kPreferredAudioOutputDevices: {
    static const WrapperTypeInfo* const wti_list[] = {
V8MediaDevices::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kRTCEncodedFrameSetMetadata: {
    static const WrapperTypeInfo* const wti_list[] = {
V8RTCEncodedAudioFrame::GetWrapperTypeInfo(), 
V8RTCEncodedVideoFrame::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kShadowRootReferenceTarget: {
    static const WrapperTypeInfo* const wti_list[] = {
V8ShadowRoot::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kSharedWorker: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kSoftNavigationHeuristics: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kTextFragmentIdentifiers: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Document::GetWrapperTypeInfo(), 
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kTouchEventFeatureDetection: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Document::GetWrapperTypeInfo(), 
V8HTMLElement::GetWrapperTypeInfo(), 
V8MathMLElement::GetWrapperTypeInfo(), 
V8SVGElement::GetWrapperTypeInfo(), 
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kTranslationAPI: {
    static const WrapperTypeInfo* const wti_list[] = {
V8DedicatedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8ServiceWorkerGlobalScope::GetWrapperTypeInfo(), 
V8SharedWorkerGlobalScope::GetWrapperTypeInfo(), 
V8Window::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kWebGPUCompatibilityMode: {
    static const WrapperTypeInfo* const wti_list[] = {
V8GPUSupportedLimits::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kWebXRImageTracking: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Window::GetWrapperTypeInfo(), 
V8XRFrame::GetWrapperTypeInfo(), 
V8XRSession::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  case mojom::blink::OriginTrialFeature::kWebXRPlaneDetection: {
    static const WrapperTypeInfo* const wti_list[] = {
V8Window::GetWrapperTypeInfo(), 
V8XRFrame::GetWrapperTypeInfo(), 
};
selected_wti_list = wti_list;
    break;
  }
  default: {
    // Ignore unknown, deprecated, and unused features.
return;
  }
}

InstallPropertiesPerFeatureInternal(script_state, feature, selected_wti_list);
}

}  // namespace bindings

}  // namespace blink
