// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_WORKLET_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_WORKLET_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_request_credentials.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT WorkletOptions : public bindings::InputDictionaryBase {
  
  public:
static WorkletOptions* Create() {
  return MakeGarbageCollected<WorkletOptions>();
}
static WorkletOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WorkletOptions>(isolate);
}
static WorkletOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WorkletOptions();
explicit  WorkletOptions(v8::Isolate* isolate);

bool hasCredentials() const {
  return true;
}
V8RequestCredentials credentials() const {
  return member_credentials_;
}
void setCredentials(V8RequestCredentials value) {
  member_credentials_ = value;
}
void setCredentials(V8RequestCredentials::Enum value) {
  member_credentials_ = V8RequestCredentials(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8RequestCredentials member_credentials_{V8RequestCredentials::Enum::kSameOrigin};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_WORKLET_OPTIONS_H_
