// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_VIEW_TIMELINE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_VIEW_TIMELINE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_scroll_axis.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class CSSNumericValue;
class Element;
class ExceptionState;
class V8UnionCSSNumericValueOrString;
class V8UnionCSSNumericValueOrStringSequenceOrString;

class CORE_EXPORT ViewTimelineOptions : public bindings::InputDictionaryBase {
  
  public:
static ViewTimelineOptions* Create() {
  return MakeGarbageCollected<ViewTimelineOptions>();
}
static ViewTimelineOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ViewTimelineOptions>(isolate);
}
static ViewTimelineOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ViewTimelineOptions();
explicit  ViewTimelineOptions(v8::Isolate* isolate);

bool hasAxis() const {
  return true;
}
V8ScrollAxis axis() const {
  return member_axis_;
}
void setAxis(V8ScrollAxis value) {
  member_axis_ = value;
}
void setAxis(V8ScrollAxis::Enum value) {
  member_axis_ = V8ScrollAxis(value);
}

bool hasInset() const {
  return true;
}
V8UnionCSSNumericValueOrStringSequenceOrString* inset() const {
  return member_inset_.Get();
}
void setInset(V8UnionCSSNumericValueOrStringSequenceOrString* value) {
  member_inset_ = value;
DCHECK(member_inset_);
}

bool hasSubject() const {
  return has_subject_;
}
Element* subject() const {
  DCHECK(hasSubject());
return member_subject_.Get();
}
Element* getSubjectOr(Element* fallback_value) const {
  if (!hasSubject()) {
  return fallback_value;
}
return member_subject_.Get();
}
void setSubject(Element* value) {
  member_subject_ = value;
has_subject_ = true;
DCHECK(member_subject_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_subject_ = false;

V8ScrollAxis member_axis_{V8ScrollAxis::Enum::kBlock};
Member<V8UnionCSSNumericValueOrStringSequenceOrString> member_inset_;
Member<Element> member_subject_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_VIEW_TIMELINE_OPTIONS_H_
