// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_UNSIGNEDLONG_UNSIGNEDLONGSEQUENCE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_UNSIGNEDLONG_UNSIGNEDLONGSEQUENCE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionUnsignedLongOrUnsignedLongSequence final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kUnsignedLong, kUnsignedLongSequence
};

static V8UnionUnsignedLongOrUnsignedLongSequence* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionUnsignedLongOrUnsignedLongSequence(uint32_t value) : content_type_(ContentType::kUnsignedLong), member_unsigned_long_(value) {
  
}
explicit  V8UnionUnsignedLongOrUnsignedLongSequence(const Vector<uint32_t>& value);
explicit  V8UnionUnsignedLongOrUnsignedLongSequence(Vector<uint32_t>&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsUnsignedLong() const {
  return content_type_ == ContentType::kUnsignedLong;
}
uint32_t GetAsUnsignedLong() const {
  DCHECK_EQ(content_type_, ContentType::kUnsignedLong);
return member_unsigned_long_;
}
void Set(uint32_t value) {
  Clear();
member_unsigned_long_ = value;
content_type_ = ContentType::kUnsignedLong;
}

bool IsUnsignedLongSequence() const {
  return content_type_ == ContentType::kUnsignedLongSequence;
}
const Vector<uint32_t>& GetAsUnsignedLongSequence() const {
  DCHECK_EQ(content_type_, ContentType::kUnsignedLongSequence);
return member_unsigned_long_sequence_;
}
void Set(const Vector<uint32_t>& value);
void Set(Vector<uint32_t>&& value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(sequence<unsigned long> or unsigned long)";
}

ContentType content_type_;

uint32_t member_unsigned_long_;
Vector<uint32_t> member_unsigned_long_sequence_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_UNSIGNEDLONG_UNSIGNEDLONGSEQUENCE_H_
